% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survCurve.R
\name{survCurve}
\alias{survCurve}
\title{Draws a survival curve for one group and one event.}
\usage{
survCurve(
  x,
  group,
  event,
  conf.int = FALSE,
  mark.time = FALSE,
  col = "black",
  lty = 1,
  lwd = 1,
  cex.markTime = 1,
  pch.markTime = 3,
  col.confInt = 1,
  lty.confInt = 2,
  lwd.confInt = 1,
  invert = FALSE
)
}
\arguments{
\item{x}{A survfit or a Cuminc object.}

\item{group}{Number of the chosen group. If the model-object has only one
Strata (Group), this parameter can be omitted.}

\item{event}{If the model-object is a multistate-model, the event-type
needs to be specified.}

\item{conf.int}{The confidence-interval is plotted as lines if TRUE. 
Default is FALSE}

\item{mark.time}{The times of censoring are marked if TRUE. Default
is FALSE}

\item{col}{Color of the line. Default is "black".}

\item{lty}{Line-type of the line. Default is 1.}

\item{lwd}{Line-wide of the line. Default is 1.}

\item{cex.markTime}{Size of the marks for censoring. Default is 1.}

\item{pch.markTime}{Character of the marks for censoring. Default is
1 (stroke).}

\item{col.confInt}{Color of the line for the confidence interval. Default is "black".}

\item{lty.confInt}{Line-type of the line for the confidence interval. Default is 2.}

\item{lwd.confInt}{Line-wide of the line for the confidence interval. Default is 1.}

\item{invert}{Inverts the curve if TRUE. Default is FALSE.}
}
\value{
Draws the survival curve for one group / one event.
}
\description{
This function draws the confident interval area of one group of a survfit 
object. For Competitive risk analysis, the event number needs to be 
specified.
}
\examples{
  require(survival)
  aml_model <- with(aml, survfit(Surv(time, status)~x))
  col1 <- adjustcolor("red",0.2); col2 <- adjustcolor("blue",0.2)
  survPlot(xmax=50, space.nrAtRisk=0.32)
  confIntArea(aml_model, col=col1, group=1)
  confIntArea(aml_model, col=col2, group=2)
  survCurve(aml_model, group=1)
  survCurve(aml_model, group=2, lty=2)
  nrAtRisk(aml_model, group=1, y=-0.17, bgcol.flag=col1, label="maintain")
  nrAtRisk(aml_model, group=2, y=-0.24, bgcol.flag=col2, lty.flag=2, label="non-maint.")
}
