% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superdiag.R
\name{superdiag}
\alias{superdiag}
\title{Test for Markov Chain Nonconvergence}
\usage{
superdiag(
  mcmcoutput,
  burnin,
  terms = "all",
  plot = FALSE,
  confidence.gr = 0.95,
  frac1.gw = 0.1,
  frac2.gw = 0.5,
  eps.hw = 0.1,
  pvalue.hw = 0.05,
  q.rl = 0.025,
  r.rl = 0.005,
  s.rl = 0.95,
  eps.rl = 0.001,
  bins = 5,
  binwidth = NULL
)
}
\arguments{
\item{mcmcoutput}{A \code{mcmc} or \code{mcmc.list} object.}

\item{burnin}{The number of burn-in iterations. Defaults to half of the chain(s).}

\item{terms}{The convergence diagnostic methods. Defaults to all five methods.
Users can also specify one or more particular methods chosen from "\code{geweke}",
"\code{heidel}", "\code{raftery}", "\code{gelman}", "\code{hellinger}".}

\item{plot}{Logical values indicates whether a graph of \code{superdiagPlot}
should be presented with a run of the function. Defaults to \code{FALSE}.}

\item{confidence.gr}{(1-\eqn{\alpha})\% for the Gelman and Rubin test. The upper
95\% credible interval is the default.}

\item{frac1.gw}{frac1 for the Geweke test. The proportion of the early era of
the chain, defaulted to 0.1.}

\item{frac2.gw}{frac2 for the Geweke test. The proportion of the late era of
the chain, defaulted to 0.5.}

\item{eps.hw}{\code{epsilon} for the Heidelberger and Welch test. The accuracy
parameter determines whether the halfwidth is passed or not, defaulted to 0.1.}

\item{pvalue.hw}{p-value for the Heidelberger and Welch test. The halfwidth of
the test calculates a (1-\eqn{\alpha})\% credible interval around the sample
mean for each parameter dimension. The default is 0.05.}

\item{q.rl}{q-parameter for the Raftery and Lewis test. The posterior tail threshold
of interest, defaulted to 0.025.}

\item{r.rl}{r-parameter for the Raftery and Lewis test. The tolerance for the
tail threshold, defaulted to 0.0005.}

\item{s.rl}{s-parameter for the Raftery and Lewis test. The desired probability
of being within the tolerance, defaulted to 0.95.}

\item{eps.rl}{convergence epsilon for the Raftery and Lewis test. The convergence
tolerance value, which is used to determine a stopping point based on a parallel chain process, defaulted to 0.001.}

\item{bins}{Number of bins for within-chain Hellinger distance test. Defaults to 5.}

\item{binwidth}{Alternative specification for \code{bins}. The size of bin for each batch
of the chain(s) for computing the distance between batches.}
}
\value{
A list object including the results for all the diagnostics. A \code{superdiagPlot}
  including both traceplot(s) and density histogram will also be returned if \code{plot=TRUE}.
}
\description{
The \code{superdiag} function takes MCMC samples as input. It provides a comprehensive
  test suite for Markov chain nonconvergence, which integrates five standard
  empirical MCMC convergence diagnostics: Gelman-Rubin, Geweke, Heidelberger-Welch,
  Raftery-Lewis, Hellinger distance. It can also present trace plots and density
  histograms along with the diagnostics as options.
}
\details{
If only one chain is analyzed, the default settings in \code{boa} and
  \code{coda} for Geweke, Raftery-Lewis, and Heidelberger-Welch diagnostics are
  used. If multiple chains are provided, only the first chain uses the defaults
  and all other chain analyses get random values as follows. For Geweke test,
  random non-overlapping proportions up from the start of the chain and down
  from the end of the chain are generated. For Heidelberger-Welch test, the
  value of \code{pvalue.hw} is sampled with replacement from common \eqn{\alpha}
  values; the value of \code{eps.hw} is sampled uniformly in the interval [0.01:0.2].
  For Raftery-Lewis test, each of these four parameters are sample from a vector
  (changeable by users) of values around the defaults (larger and smaller) to
  provide a reasonable range of alternatives. For Hellinger distance, if only
  one chain is analyzed, only within-chain distance will be reported.
}
\examples{
\dontrun{

data(tobit.list)
summary(tobit.list[1])

# FOR mcmc.list OBJECT
superdiag(tobit.list, burnin=0)

# FOR mcmc OBJECT
tobit.diag <- superdiag(tobit.list[[1]], burnin=0, plot=TRUE)
tobit.diag
}

}
\references{
Tsai, Tsung-han and Gill, Jeff (2012). \dQuote{superdiag: A Comprehensive Test
    Suite for Markov Chain Non-Convergence.} \emph{The Political Methodologist},
    19 (2), 12-18.

  Plummer, Martyn, Nicky Best, Kate Cowles, and Karen Vines (2006). "CODA: convergence
     diagnosis and output analysis for MCMC." \emph{R news}, 6 (1), 7-11.
}
\seealso{
\code{\link{superdiagPlot}}, \code{\link[coda]{gelman.diag}}, \code{\link[coda]{heidel.diag}},
  \code{\link[coda]{raftery.diag}}, \code{\link[coda]{gelman.diag}}
}
