% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_css.R
\name{st_css}
\alias{st_css}
\title{Include \strong{summarytools}' \emph{css} Into Active Document}
\usage{
st_css(main = TRUE, global = FALSE, bootstrap = FALSE, style.tag = TRUE, ...)
}
\arguments{
\item{main}{Logical. Include \emph{summarytools.css} file. \code{TRUE} by
default. This will affects only \strong{summarytools} objects, for one
exception: two properties of the \code{img} tag are redefined to have
\code{background-color: transparent} and \code{border: 0}.}

\item{global}{Logical. Include the additional \emph{summarytools-global.css}
file, which affects all content in the document. Provides control over
objects that were not \emph{html-rendered}; in particular, table widths
and vertical alignment are modified to improve layout. \code{FALSE} by
default.}

\item{bootstrap}{Logical. Include \emph{bootstrap.min.css}. \code{FALSE}
by default.}

\item{style.tag}{Logical. Include the opening and closing \code{<style>}
tags. \code{TRUE} by default.}

\item{\dots}{Character. Path to additional \emph{css} file(s) to include.}
}
\value{
The \emph{css} file(s) content silently as a character vector, and
  prints (using \code{cat()}) the content.
}
\description{
Generate the \emph{css} needed by \strong{summarytools} in \emph{html}
documents.
}
\details{
Typically the function is called right after the initial setup chunk
  of an \emph{R markdown} document, in a chunk having options
  \code{echo=FALSE} and \code{results="asis"}.
}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com}
}
\keyword{utilities}
