\name{substr_position}
\alias{substr_position}
\title{Compute Row Index of a Substring in a Substring Data Frame}
\description{
Computes the row index of a substring in the data frame created by \code{\link{init_substr_info}}, given its starting position, its length in tokens, and the total number of tokens.

This is an internal helper function.
}
\usage{
substr_position(start, n_tokens, N)
}
\arguments{
  \item{start}{Integer (or integer vector). The starting position of the substring (1-based).}
  \item{n_tokens}{Integer (or integer vector). The number of tokens in the substring.}
  \item{N}{Integer. The total number of tokens in the full token sequence.}
}
\details{
The data frame returned by \code{\link{init_substr_info}} is ordered by \code{n_tokens} descending and \code{start} ascending. This function computes the corresponding row index using the formula

\deqn{\mathrm{row} = \frac{(N - k)(N - k + 1)}{2} + s}{row = (N - k)(N - k + 1) / 2 + s}

where \eqn{k} = \code{n_tokens} and \eqn{s} = \code{start}.

The function is vectorized: if \code{start} and \code{n_tokens} are vectors of the same length, a vector of row indices is returned.
}
\value{
A numeric vector of row indices (1-based).
}
\seealso{
\code{\link{init_substr_info}} for creating the substring data frame
}
\examples{

# Create a character vector with tokens
x <- "<d-nu-dim2-mud> ki a. jal2 (e2{kur}) ra. gaba jal2. an ki a"
token <- split_sumerian(as.cuneiform(x))$signs
token

N <- length(token)

# Create a data frame with all substrings
df <- sumer:::init_substr_info(token)

# The full string (start=1, n_tokens=N) is in row 1
pos <- sumer:::substr_position(1, N, N)
pos
df$expr[pos]


# The last single token (start=N, n_tokens=1) is in the last row
pos <- sumer:::substr_position(N, 1, N)
pos
df$expr[pos]

# Vectorized call
start <- c(1, 2, 1)
n_token <- c(2, 2, 1)
pos <- sumer:::substr_position(start, n_token, N)
pos
df$expr[pos]
}
\keyword{internal}
