\name{sign_grammar}
\alias{sign_grammar}
\title{Grammatical Type Frequencies for Each Sign in a Sumerian Sentence}
\description{
For each cuneiform sign in a Sumerian sentence, looks up the dictionary to
determine the frequency of each individual grammatical type (e.g., \code{S},
\code{V}, \code{Sx->S}, \code{xS->A}). Returns a data frame with one row
per sign per grammatical type.
}
\usage{
sign_grammar(x, dic, mapping = NULL)
}
\arguments{
  \item{x}{A single character string containing a Sumerian sentence
    (cuneiform, sign names, or transliteration).}

  \item{dic}{A dictionary data frame as returned by
    \code{\link{read_dictionary}}.}

  \item{mapping}{A data frame containing the sign mapping table with columns \code{syllables}, \code{name}, and \code{cuneiform}. If \code{NULL} (the default), the package's internal mapping file \file{etcsl_mapping.txt} is loaded.}
}
\details{
The function converts the input to cuneiform, splits it into individual
signs, and looks up each sign in the dictionary. For each sign, the
translations are grouped by their individual type string
(e.g., \code{"S"}, \code{"V"}, \code{"Sx->S"}, \code{"xS->A"}).

For each type the dictionary \code{count} values are summed. If a
translation entry has no count, it is treated as 1.

The set of types returned is the union of all types found across all
signs in the sentence. Each sign gets one row per type, even if the
count is 0 for that type.
}
\value{
A data frame with columns:
\describe{
  \item{position}{Integer. Position of the sign in the sentence.}
  \item{sign_name}{Character. The sign name (e.g., \code{"KA"}).}
  \item{cuneiform}{Character. The cuneiform character.}
  \item{type}{Character. The grammar type string (e.g., \code{"S"},
    \code{"V"}, \code{"Sx->S"}).}
  \item{n}{Integer. Sum of dictionary counts for this sign and this type.}
}
}
\examples{
dic <- read_dictionary()

# Analyse a sentence
sg <- sign_grammar("a-ma-ru ba-ur3 ra", dic)
print(sg)

# Use with cuneiform input
x<-"\U00012000\U000121AD"
print(x)
sg <- sign_grammar(x, dic)
print(sg)
}
\seealso{
\code{\link{grammar_probs}} for Bayesian posterior probabilities,
\code{\link{plot_sign_grammar}} for visualising the result,
\code{\link{read_dictionary}} for loading a dictionary,
\code{\link{as.cuneiform}} for cuneiform conversion.
}
\keyword{utilities}
