\name{mark_skeleton_entries}
\alias{mark_skeleton_entries}
\title{Normalize Brackets for Skeleton Generation}
\description{
Transforms a transliterated Sumerian text string into a normalized form that contains only round brackets. This prepares the input for hierarchical extraction by \code{\link{extract_skeleton_entries}}.

This is an internal helper function used by \code{\link{skeleton}}.
}
\usage{
mark_skeleton_entries(x)
}
\arguments{
  \item{x}{A character string of length 1 containing transliterated Sumerian text. The string may contain angle brackets (\code{< >}), round brackets (\code{( )}), and curly braces (\code{\{ \}}) to annotate token groups (see Details).}
}
\details{
The function performs the following transformations:

\enumerate{
  \item Tokenizes the input using an internal helper function. Tokens enclosed in angle brackets are merged into a single token.
  \item Removes all angle brackets and curly braces from the separators, replacing them with spaces.
  \item Wraps every token that is not already enclosed in round brackets with round brackets.
}

The result is a string in which every token is enclosed in round brackets. Existing round brackets from the input are preserved, so the nesting structure reflects the grouping specified in the original input.

For example, the input

\code{"<d-nu-dim2-mud> ki a. jal2 (e2{kur}) ra"}

is transformed into a string where \code{d-nu-dim2-mud} appears as a single bracketed token, \code{e2} and \code{kur} are individually bracketed inside the existing round brackets around \code{e2\{kur\}}, and all other tokens (\code{ki}, \code{a}, \code{jal2}, \code{ra}) are each wrapped in their own round brackets.
}
\value{
A character string of length 1 in which all tokens are enclosed in round brackets. The string contains only round brackets as grouping characters (no angle brackets or curly braces).
}
\seealso{
\code{\link{skeleton}} which calls this function,
\code{\link{extract_skeleton_entries}} for the subsequent extraction step,
\code{\link{split_sumerian}} for the underlying sign-splitting logic
}
\examples{
# Input with all three bracket types
x <- "<d-nu-dim2-mud> ki a. jal2 (e2{kur}) ra. gaba jal2. an ki a"
sumer:::mark_skeleton_entries(x)

# Input without any brackets: each token gets wrapped in round brackets
sumer:::mark_skeleton_entries("LUGAL.E")

# Angle brackets merge tokens into a single unit
sumer:::mark_skeleton_entries("<an-ki> lugal")
}
\keyword{internal}
