\name{extract_skeleton_entries}
\alias{extract_skeleton_entries}
\title{Extract Hierarchical Skeleton Entries from Bracketed Text}
\description{
Recursively extracts the contents of nested round brackets from a normalized Sumerian text string and returns them as a data frame with position, length, nesting depth, and expression for each entry.

This is an internal helper function used by \code{\link{skeleton}}.
}
\usage{
extract_skeleton_entries(x)
}
\arguments{
  \item{x}{A character string containing Sumerian text with round brackets, as returned by \code{\link{mark_skeleton_entries}}.}
}
\details{
The function first extracts the contents of all outermost (top-level) bracket pairs using an internal helper function. For each extracted group, a row is added to the result data frame. If a group itself contains further nested brackets, the function recurses into it to extract deeper levels.

The \code{depth} value of each entry reflects the nesting level: entries from the outermost brackets have depth 1, entries nested one level deeper have depth 2, and so on.

The \code{start} column records the position (in tokens) of the first token in each group, relative to the full input. The \code{n_tokens} column gives the number of tokens in the group as determined by \code{\link{split_sumerian}}.
}
\value{
A data frame with one row per extracted entry and the following columns:
  \item{start}{Integer. The token position of the first token in the group (1-based).}
  \item{n_tokens}{Integer. The number of Sumerian tokens (signs) in the group.}
  \item{depth}{Integer. The nesting depth of the entry (1 for top-level groups, 2 for groups nested one level deeper, etc.).}
  \item{expr}{Character. The text content of the bracket group (without the surrounding brackets).}

If the input contains no brackets, an empty data frame with the same columns is returned.
}
\seealso{
\code{\link{skeleton}} which calls this function,
\code{\link{mark_skeleton_entries}} for the preceding normalization step,
\code{\link{split_sumerian}} for determining the number of tokens
}
\examples{
# First normalize the input with mark_skeleton_entries
x <- "<d-nu-dim2-mud> ki a. jal2 (e2{kur}) ra. gaba jal2. an ki a"
normalized <- sumer:::mark_skeleton_entries(x)
normalized

# Then extract the hierarchical structure
sumer:::extract_skeleton_entries(normalized)
}
\keyword{internal}
