## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  dev = "ragg_png"
)

## -----------------------------------------------------------------------------
library(sumer)

## -----------------------------------------------------------------------------
path <- system.file("extdata", "enki_and_the_world_order.txt", package = "sumer")
text <- readLines(path, encoding = "UTF-8")

## -----------------------------------------------------------------------------
cat(text[1:5], sep = "\n")

## -----------------------------------------------------------------------------
freq <- ngram_frequencies(text, min_freq = c(6, 4, 2))
head(freq, 10)

## -----------------------------------------------------------------------------
text_marked <- mark_ngrams(text, freq)
cat(text_marked[1:5], sep = "\n")

## -----------------------------------------------------------------------------
term    <- "IGI.DIB.TU"
pattern <- mark_ngrams(term, freq)
pattern
result  <- text_marked[grepl(pattern, text_marked, fixed = TRUE)]
cat(result, sep = "\n")

## -----------------------------------------------------------------------------
dic <- read_dictionary()
sg  <- sign_grammar("a-ma-ru ba-ur3 ra", dic)

## -----------------------------------------------------------------------------
prior <- prior_probs(dic, sentence_prob = 0.25)

## -----------------------------------------------------------------------------
gp <- grammar_probs(sg, prior, dic)

## ----fig.width = 7, fig.height = 4--------------------------------------------
plot_sign_grammar(gp, sign_names = FALSE)

## ----eval = FALSE-------------------------------------------------------------
# plot_sign_grammar(gp, output_file = "grammar.png")

## ----eval = FALSE-------------------------------------------------------------
# result <- translate(3, text = text)

## ----eval = FALSE-------------------------------------------------------------
# result <- translate(3, text = text)
# writeLines(result, "line_003.txt")

## ----eval = FALSE-------------------------------------------------------------
# result <- translate(3, text = text,
#               dic = c(system.file("extdata", "sumer-dictionary.txt", package = "sumer"),
#                       "my_dictionary.txt"))

## ----eval = FALSE-------------------------------------------------------------
# dictionary <- make_dictionary("line_003.txt")

## ----eval = FALSE-------------------------------------------------------------
# # Step 1: Read translation files
# translations <- read_translated_text("line_003.txt")
# 
# # Step 2: Convert to dictionary format
# dictionary <- convert_to_dictionary(translations)

## ----eval = FALSE-------------------------------------------------------------
# save_dictionary(
#   dic     = dictionary,
#   file    = "my_dictionary.txt",
#   author  = "My Name",
#   year    = "2026",
#   version = "1.0",
#   url     = "https://example.com/dictionary"
# )

## ----eval = FALSE-------------------------------------------------------------
# my_dic <- read_dictionary("my_dictionary.txt")
# look_up("ki", my_dic)

## ----eval = FALSE-------------------------------------------------------------
# # For lookup
# look_up("lugal", my_dic)
# 
# # For interactive translation
# result <- translate(4, text = text, dic = "my_dictionary.txt")

