

.onAttach <- function(libname, pkgname) {
  msg <- ""

  if (interactive()) {
    backend <- getOption("RStudioGD.backend", default = "default")
    if (!identical(backend, "ragg")) {
      msg <- paste0(
        "Note: The graphics backend may not be set to AGG, so cuneiform characters may not render correctly. For best results:\n",
        "  - install.packages(\"ragg\")\n",
        "  - In RStudio: Tools > Global Options > General > Graphics > ",
        "Backend > select \"AGG\"\n"
      )
    }
  }

  if(msg==""){
    msg <- switch(sample.int(2L, 1L),
        "Watch for dictionary updates:\n    https://founder-hypothesis.com/en/sumerian-mythology/downloads/",
        "Type 'browseVignettes(\"sumer\")' to get started.")
  }

  packageStartupMessage(msg)
}
