% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsampling_pkg.R
\docType{package}
\name{subsampling}
\alias{subsampling-package}
\alias{subsampling}
\title{Optimal Subsampling Methods for Statistical Models}
\description{
Subsampling methods are utilized in statistical modeling for
massive datasets. These methods aim to draw representative subsamples from the
full dataset based on specific sampling probabilities, with the goal of
maintaining inference efficiency. The sampling probabilities are tailored to
particular objectives, such as minimizing the variance of the estimated
coefficients or reducing prediction error. By using subsampling techniques,
the package balances the trade-off between computational efficiency and statistical
efficiency, making it a practical tool for massive data
analysis.
}
\section{Models Supported}{

\itemize{
\item Generalized Linear Models (GLMs)
\item Softmax (Multinomial) Regression
\item Rare Event Logistic Regression
\item Quantile Regression
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/dqksnow/Subsampling}
  \item Report bugs at \url{https://github.com/dqksnow/Subsampling/issues}
}

}
\author{
\strong{Maintainer}: Qingkai Dong \email{qingkai.dong@uconn.edu} [copyright holder]

Authors:
\itemize{
  \item Yaqiong Yao
  \item Haiying Wang
}

Other contributors:
\itemize{
  \item Qiang Zhang [contributor]
  \item Jun Yan [contributor]
}

}
