% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_core.R
\name{cv_core}
\alias{cv_core}
\title{Cross Validation Function}
\usage{
cv_core(object, data, t_groups, ...)
}
\arguments{
\item{object}{Currently `"reg_sine", "reg_asym", "lm", "mlm_stressor"`
objects are accepted.}

\item{data}{A data.frame object that has the same formula that was fitted on
the data.}

\item{t_groups}{The groups for cross validation: standard cross validation,
LOO cross_validation, or spatial cross validation.}

\item{...}{Additional arguments that are passed to the predict function.}
}
\value{
Either a vector of predictions for `"reg_sine", "reg_asym", "lm"` and
  a data frame for `"mlm_stressor"`.
}
\description{
This is the machinery to run cross validation. It subsets the test and train
 set based on the groups it receives.
}
\examples{
 # lm example
 lm_test <- data_gen_lm(20)
 lm <- lm(Y ~ ., lm_test)
 cv(lm, lm_test, n_folds = 2)

\dontshow{if (python_avail()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
 lm_test <- data_gen_lm(20)
 create_virtualenv()
 mlm_lm <- mlm_regressor(Y ~ ., lm_test)
 cv(mlm_lm, lm_test, n_folds = 2)
\dontshow{\}) # examplesIf}
 # Asymptotic example
 asym_data <- data_gen_asym(10)
 asym_fit <- reg_asym(Y ~ ., asym_data)
 cv(asym_fit, asym_data, n_folds = 2)

 # Sine example
 sine_data <- data_gen_sine(10)
 sine_fit <- reg_sine(Y ~ ., sine_data)
 cv(sine_fit, sine_data, n_folds = 2)
}
