% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSRegressor_SlidingWindow.R
\name{DSRegressor_SlidingWindow}
\alias{DSRegressor_SlidingWindow}
\title{DSRegressor_SlidingWindow -- Data Stream Regressor Using a Sliding Window}
\usage{
DSRegressor_SlidingWindow(formula, model = stats::lm, window, rebuild, ...)
}
\arguments{
\item{formula}{a formula for the classification problem.}

\item{model}{regression model (that has a formula interface).}

\item{window}{size of the sliding window.}

\item{rebuild}{interval (number of points) for rebuilding the regression. Set rebuild to
\code{Inf} to prevent automatic rebuilding. Rebuilding can be initiated manually when
calling \code{update()}.}

\item{...}{additional parameters are passed on to the regressor (default is \code{lm()}).}
}
\value{
An object of class \code{DST_SlidingWindow}.
}
\description{
The Regressor keeps a sliding window for the stream and rebuilds a regression model at regular
intervals. By default is builds a decision tree using \code{\link[=lm]{lm()}}.
}
\details{
This constructor creates a regressor based on \code{\link{DST_SlidingWindow}}. The regressor has
a \code{update()} and \code{predict()} method.
}
\examples{
library(stream)

# create a data stream for the iris dataset
data <- iris[sample(nrow(iris)), ]
stream <- DSD_Memory(data)

# define the stream Regressor.
cl <- DSRegressor_SlidingWindow(
  Sepal.Length ~ Petal.Length + Petal.Length,
  window = 50,
  rebuild = 10
  )
cl

# update the regressor with 100 points from the stream
update(cl, stream, 100)

# predict the class for the next 50 points
newdata <- get_points(stream, n = 50)
pr <- predict(cl, newdata)
pr

plot(pr, newdata$Sepal.Length)
abline(0, 1, col = "red")

# get the tree model
get_model(cl)
}
\seealso{
Other DSRegressor: 
\code{\link{DSRegressor}()}
}
\author{
Michael Hahsler
}
\concept{DSRegressor}
