% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSD_mlbenchData.R
\name{DSD_mlbenchData}
\alias{DSD_mlbenchData}
\title{Stream Interface for Data Sets From mlbench}
\usage{
DSD_mlbenchData(data = NULL, loop = FALSE, random = FALSE, scale = FALSE)
}
\arguments{
\item{data}{The name of the dataset from mlbench. If missing then a list of
all available data sets is shown and returned.}

\item{loop}{logical; loop or not to loop over the
data frame.}

\item{random}{logical; should the data be used a random order?}

\item{scale}{logical; apply scaling to the data?}
}
\value{
Returns a \code{DSD_mlbenchData} object which is also of class
\link{DSD_Memory}.
}
\description{
Provides a convenient stream interface for data sets from the mlbench
package.
}
\details{
The \code{DSD_mlbenchData} class is designed to be a wrapper class for data
from the mlbench package.

All data is held in memory in either data frame or matrix form. It is served as a stream using the
\link{DSD_Memory} class. The stream can be reset to position 1 using \code{\link[=reset_stream]{reset_stream()}}.

Call \code{DSD_mlbenchData} with a missing value for \code{data} to get a list of
all available data sets.
}
\examples{
DSD_mlbenchData()

stream <- DSD_mlbenchData("Shuttle")
stream

get_points(stream, n = 5)

plot(stream, n = 100)
}
\seealso{
Other DSD: 
\code{\link{DSD}()},
\code{\link{DSD_BarsAndGaussians}()},
\code{\link{DSD_Benchmark}()},
\code{\link{DSD_Cubes}()},
\code{\link{DSD_Gaussians}()},
\code{\link{DSD_MG}()},
\code{\link{DSD_Memory}()},
\code{\link{DSD_Mixture}()},
\code{\link{DSD_NULL}()},
\code{\link{DSD_ReadDB}()},
\code{\link{DSD_ReadStream}()},
\code{\link{DSD_Target}()},
\code{\link{DSD_UniformNoise}()},
\code{\link{DSD_mlbenchGenerator}()},
\code{\link{DSF}()},
\code{\link{animate_data}()},
\code{\link{close_stream}()},
\code{\link{get_points}()},
\code{\link{plot.DSD}()},
\code{\link{reset_stream}()}
}
\author{
Michael Hahsler and Matthew Bolanos
}
\concept{DSD}
