% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_beds.R
\name{merge_beds}
\alias{merge_beds}
\title{merge beds in stratigraphic column}
\usage{
merge_beds(s, mode = "identical facies", ...)
}
\arguments{
\item{s}{stratigraphic column (a \code{stratcol} object)}

\item{mode}{character. criteria for merging. currently only "identical facies" is implemented}

\item{...}{other parameters. currently not used}
}
\value{
a stratigraphic column (a \code{stratcol} object)
}
\description{
merge beds in stratigraphic column
}
\examples{
s = as_stratcol(c(0.5, 1, 0.3, 0.7), c("sand", "sand", "shale", "shale"), L_unit = "m")
merge_beds(s, mode = "identical facies")
facies = facies_names(s) # returns "sand" "shale" as the two sandy beds are merged
}
