% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{is.dummy}
\alias{is.dummy}
\title{Test for a Dummy Variable}
\usage{
is.dummy(x, any.values = FALSE)
}
\arguments{
\item{x}{atomic vector.}

\item{any.values}{logical vector of length 1 specifying whether the two observed values
need to be 0 or 1 (FALSE) or can be any values (TRUE).}
}
\value{
TRUE if `x` is a dummy variable; FALSE otherwise.
}
\description{
\code{is.dummy} returns whether a numeric vector is a dummy variable, meaning
all elements one of two observed values (or missing values). Depending on the argument
\code{any.values}, the two observed values are required to be 0 and 1 or any values.
}
\examples{

# any.values = FALSE (default)
is.dummy(mtcars$"am") # TRUE
is.dummy(c(mtcars$"am", NA, NaN)) # works with missing values
is.dummy(c(as.integer(mtcars$"am"), NA, NaN)) # works with typeof integer
x <- ifelse(mtcars$"am" == 1, yes = 2, no = 1)
is.dummy(x) # FALSE

# any.values = TRUE
is.dummy(x, any.values = TRUE) # TRUE
is.dummy(c(x, NA), any.values = TRUE) # work with missing values
is.dummy(c(as.character(x), NA), any.values = TRUE) # work with typeof character
is.dummy(mtcars$"gear") # FALSE for nominal variables with more than 2 levels

}
