% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simulate_hawkes_stpp_nonunif}
\alias{simulate_hawkes_stpp_nonunif}
\title{Simulate inhomogenous spatio-temporal hawkes model}
\usage{
simulate_hawkes_stpp_nonunif(params, poly, t_region, d, history, seed = -1L)
}
\arguments{
\item{params}{- list containing params (\eqn{\mu}, \eqn{a}, \eqn{b}, \eqn{\sigma},\eqn{\mu x}, \eqn{\mu y}, \eqn{\sigma x}, \eqn{\sigma y} )}

\item{poly}{- matrix defining polygon (\eqn{N} x \eqn{2})}

\item{t_region}{- vector of two elements describing time region (e.g., c(0,10))}

\item{d}{- generate parents on larger polygon by expanded observed polygon by d (default = R::qnorm(.95, 0, sig, 1, 0))}

\item{history}{- history of process (e.g., numeric())}

\item{seed}{- set random number seed (default=-1)}
}
\value{
A DataFrame containing \eqn{x},\eqn{y},\eqn{t}
}
\description{
Simulate inhomogenous spatio-temporal hawkes model
}
