% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snap_points_to_lines.R
\name{snap_points_to_lines}
\alias{snap_points_to_lines}
\title{Snapping point to network}
\usage{
snap_points_to_lines(points, lines,
verbose = FALSE)
}
\arguments{
\item{points}{point data (sf object)}

\item{lines}{line/street/road network (sf object)}

\item{verbose}{Whether to output processing
messages.}
}
\value{
Point (sf object) with adjusted coordinates
to fit on the network data
}
\description{
Snaps points to the nearest segment
of a network data.
}
\details{
Function snaps points (within 300m)
to the nearest segment on a network. The remaining
points outside 300m buffer are returned in
their original locations (Credit: Michal Kvasnicka)
}
\examples{

#get line and point data
#load(file = system.file("extdata", "camden.rda",
#package="stppSim"))
lines <- stppSim:::lines
pts <- stppSim:::pts
my_points <- snap_points_to_lines(points=pts,
lines=lines,
verbose = FALSE)

#preview result
#ggplot()+
#geom_sf(data = lines, col = 'red')+
#geom_sf(data = pts, shape = 1)
}
