% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srgamma.R
\name{srgamma_optimize}
\alias{srgamma_optimize}
\title{Optimizing Gamma Distribution proposal}
\usage{
srgamma_optimize(
  shape = NULL,
  rate = NULL,
  scale = NULL,
  xl = NULL,
  xr = NULL,
  steps = 4091,
  proposal_range = NULL,
  theta = 0.1,
  target_sample_size = 1000,
  verbose = FALSE
)
}
\arguments{
\item{shape}{(optional) Numeric. The shape parameter (\eqn{\alpha}) of the Gamma distribution. Defaults to \code{1}.}

\item{rate}{(optional) Numeric. The rate parameter (\eqn{\beta}) of the Gamma distribution. Defaults to \code{1}.}

\item{scale}{(optional) Numeric. The scale parameter of the Gamma distribution. Defaults to \code{1}.}

\item{xl}{Numeric. Left truncation bound for the target distribution. Defaults to \code{0}, representing no left truncation.}

\item{xr}{Numeric. Right truncation bound for the target distribution. Defaults to \code{Inf}, representing no right truncation.}

\item{steps}{(optional) Integer. Desired number of steps in the proposal. Defaults to \code{4091}.}

\item{proposal_range}{(optional) Numeric vector. Specifies the range for optimizing the steps part of the proposal. Defaults to \code{NULL}, indicating automatic range selection.}

\item{theta}{Numeric. A parameter for proposal optimization. Defaults to 0.1.}

\item{target_sample_size}{(optional) Integer. Target sample size for proposal optimization. Defaults to \code{1000}.}

\item{verbose}{Boolean. If \code{TRUE}, detailed optimization information, including areas and steps, will be displayed. Defaults to \code{FALSE}.}
}
\value{
A list containing the optimized proposal and related parameters for the specified Gamma distribution. The proposal is also cached for internal use.
\describe{
\item{\code{data}}{Detailed information about the proposal steps, including \code{x}, \code{s_upper}, \code{p_a}, and \code{s_upper_lower}.}
\item{\code{areas}}{The areas under the left tail, steps, and right tail of the proposal distribution.}
\item{\code{steps_number}}{The number of steps in the proposal.}
\item{\code{f_params}}{The parameters (\code{shape} and \code{rate}) of the Gamma distribution.}
}
}
\description{
The \code{srgamma_optimize()} function generates an optimized proposal for a targeted Gamma distribution.
The proposal can be customized and adjusted based on various options provided by the user.
}
\details{
When \code{srgamma_optimize()} is explicitly called:
\itemize{
\item A proposal is created and cached. If no parameters are provided, a standard proposal is created with \code{shape = 1} and \code{rate = 1}.
\item Providing \code{shape} and \code{rate} creates a custom proposal, which is cached for use with \code{srgamma_custom()}.
\item The optimization process can be controlled via parameters such as \code{steps}, \code{proposal_range}, or
\code{theta}. If no parameters are provided, the proposal is optimized via brute force based on the
\code{target_sample_size}.
}
}
\examples{
# Generate a standard proposal with shape = 1 and rate = 1
standard_proposal <- srgamma_optimize()

# Generate a custom proposal with shape = 2 and rate = 3
custom_proposal <- srgamma_optimize(shape = 2, rate = 3)

}
\seealso{
\code{\link{srgamma_custom}}: Function to sample from a custom proposal generated by \code{srgamma_optimize()}.
}
