% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proposal_info.R
\name{load_proposal}
\alias{load_proposal}
\title{Load Stored Proposal}
\usage{
load_proposal(proposal_name)
}
\arguments{
\item{proposal_name}{A string specifying the name of the proposal to be loaded.}
}
\value{
Returns a list representing the proposal stored under \code{proposal_name} in R's internal data directory. If the proposal corresponding to the specified name does not exist, an error message is displayed.
}
\description{
This function loads a proposal into memory that was previously saved using the \code{save_proposal()} function. It is useful for retrieving saved proposals for further analysis or processing.
}
\examples{
# First, let's create a proposal to sample from a standard normal distribution
f_normal <- function(x) { 0.3989423 * exp(-0.5 * x^2) }
normal_proposal = build_proposal(f = f_normal, modes = 0, lower = -Inf, upper = Inf, steps = 1000)
print(normal_proposal)

# Then, save this proposal in R's internal data directory using
# `save_proposal()` with the name "normal"
save_proposal(normal_proposal, "normal")

# Now, in case the R session is restarted and the proposal is no longer in memory,
# it can be loaded from the machine as follows:
loaded_normal_proposal <- load_proposal("normal")
print(loaded_normal_proposal)
}
