% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_transformation.R
\name{sample_bcf_posterior_predictive}
\alias{sample_bcf_posterior_predictive}
\title{Sample BCF Posterior Predictive}
\usage{
sample_bcf_posterior_predictive(
  model_object,
  X = NULL,
  Z = NULL,
  propensity = NULL,
  rfx_group_ids = NULL,
  rfx_basis = NULL,
  num_draws_per_sample = NULL
)
}
\arguments{
\item{model_object}{A fitted BCF model object of class \code{bcfmodel}.}

\item{X}{A matrix or data frame of covariates.}

\item{Z}{A vector or matrix of treatment assignments.}

\item{propensity}{(Optional) A vector or matrix of propensity scores. Required if the underlying model depends on user-provided propensities.}

\item{rfx_group_ids}{(Optional) A vector of group IDs for random effects model. Required if the BCF model includes random effects.}

\item{rfx_basis}{(Optional) A matrix of bases for random effects model. Required if the BCF model includes random effects.}

\item{num_draws_per_sample}{(Optional) The number of samples to draw from the likelihood for each draw of the posterior. Defaults to a heuristic based on the number of samples in a BCF model (i.e. if the BCF model has >1000 draws, we use 1 draw from the likelihood per sample, otherwise we upsample to ensure at least 1000 posterior predictive draws).}
}
\value{
Array of posterior predictive samples with dimensions (num_observations, num_posterior_samples, num_draws_per_sample) if num_draws_per_sample > 1, otherwise (num_observations, num_posterior_samples).
}
\description{
Sample from the posterior predictive distribution for outcomes modeled by BCF
}
\examples{
n <- 100
p <- 5
X <- matrix(rnorm(n * p), nrow = n, ncol = p)
pi_X <- pnorm(X[,1] / 2)
Z <- rbinom(n, 1, pi_X)
y <- 2 * X[,2] + 0.5 * X[,2] * Z + rnorm(n)
bcf_model <- bcf(X_train = X, Z_train = Z, y_train = y, propensity_train = pi_X)
ppd_samples <- sample_bcf_posterior_predictive(
  model_object = bcf_model, X = X,
  Z = Z, propensity = pi_X
)
}
