% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stenographer.R
\name{Stenographer}
\alias{Stenographer}
\title{R6 Class for Advanced Logging Functionality}
\description{
Provides a flexible logging system with support for multiple output destinations,
customisable formatting, and contextual logging. Features include:

* Multiple log levels (ERROR, WARNING, INFO)
* File-based logging
* Database logging support
* Customisable message formatting
* Contextual data attachment
* Coloured console output
}
\examples{
# Create a basic Stenographer
steno <- Stenographer$new()
steno$info("This is an info message")
steno$warn("This is a warning")
steno$error("This is an error")

# Disable all logging
steno$set_level(LogLevel$OFF)
steno$info("This won't be logged")
steno$warn("This won't be logged either")
steno$error("This also won't be logged")

# Create a logger with custom settings, message formatting, and context
custom_steno <- Stenographer$new(
  level = LogLevel$WARNING,
  file_path = tempfile("log_"),
  print_fn = function(x) message(paste0("Custom: ", x)),
  format_fn = function(level, msg) paste0("Hello prefix: ", msg),
  context = list(program = "MyApp")
)
custom_steno$info("This won't be logged")
custom_steno$warn("This will be logged with a custom prefix")

# Change log level and update context
custom_steno$set_level(LogLevel$INFO)
custom_steno$update_context(list(user = "John"))
custom_steno$info("Now this will be logged with a custom prefix and context")

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Stenographer-new}{\code{Stenographer$new()}}
\item \href{#method-Stenographer-set_level}{\code{Stenographer$set_level()}}
\item \href{#method-Stenographer-update_context}{\code{Stenographer$update_context()}}
\item \href{#method-Stenographer-clear_context}{\code{Stenographer$clear_context()}}
\item \href{#method-Stenographer-get_context}{\code{Stenographer$get_context()}}
\item \href{#method-Stenographer-error}{\code{Stenographer$error()}}
\item \href{#method-Stenographer-warn}{\code{Stenographer$warn()}}
\item \href{#method-Stenographer-info}{\code{Stenographer$info()}}
\item \href{#method-Stenographer-clone}{\code{Stenographer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stenographer-new"></a>}}
\if{latex}{\out{\hypertarget{method-Stenographer-new}{}}}
\subsection{Method \code{new()}}{
Create a new Stenographer instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stenographer$new(
  level = LogLevel$INFO,
  file_path = NULL,
  db_conn = NULL,
  table_name = "LOGS",
  print_fn = function(x) cat(x, "\\n"),
  format_fn = function(level, msg) msg,
  context = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{The minimum log level to output. Default is LogLevel$INFO.}

\item{\code{file_path}}{Character; the path to a file to save log entries to. Default is NULL.}

\item{\code{db_conn}}{DBI connection object; an existing database connection. Default is NULL.}

\item{\code{table_name}}{Character; the name of the table to log to in the database. Default is "LOGS".}

\item{\code{print_fn}}{Function; custom print function to use for console output.
Should accept a single character string as input. Default uses cat with a newline.}

\item{\code{format_fn}}{Function; custom format function to modify the log message.
Should accept level and msg as inputs and return a formatted string.}

\item{\code{context}}{List; initial context for the logger. Default is an empty list.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `Stenographer` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stenographer-set_level"></a>}}
\if{latex}{\out{\hypertarget{method-Stenographer-set_level}{}}}
\subsection{Method \code{set_level()}}{
Update the minimum logging level
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stenographer$set_level(level)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{New log level (see `LogLevel`)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stenographer-update_context"></a>}}
\if{latex}{\out{\hypertarget{method-Stenographer-update_context}{}}}
\subsection{Method \code{update_context()}}{
Add or update contextual data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stenographer$update_context(new_context)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_context}}{List of context key-value pairs}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stenographer-clear_context"></a>}}
\if{latex}{\out{\hypertarget{method-Stenographer-clear_context}{}}}
\subsection{Method \code{clear_context()}}{
Remove all contextual data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stenographer$clear_context()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stenographer-get_context"></a>}}
\if{latex}{\out{\hypertarget{method-Stenographer-get_context}{}}}
\subsection{Method \code{get_context()}}{
Retrieve current context data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stenographer$get_context()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List of current context
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stenographer-error"></a>}}
\if{latex}{\out{\hypertarget{method-Stenographer-error}{}}}
\subsection{Method \code{error()}}{
Log an error message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stenographer$error(msg, data = NULL, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{Error message text}

\item{\code{data}}{Optional data to attach}

\item{\code{error}}{Optional error object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stenographer-warn"></a>}}
\if{latex}{\out{\hypertarget{method-Stenographer-warn}{}}}
\subsection{Method \code{warn()}}{
Log a warning message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stenographer$warn(msg, data = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{Warning message text}

\item{\code{data}}{Optional data to attach}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stenographer-info"></a>}}
\if{latex}{\out{\hypertarget{method-Stenographer-info}{}}}
\subsection{Method \code{info()}}{
Log an informational message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stenographer$info(msg, data = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{Info message text}

\item{\code{data}}{Optional data to attach}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stenographer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Stenographer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stenographer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
