% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate_lm2}
\alias{validate_lm2}
\title{Validate Inputs for lm2() Function}
\usage{
validate_lm2(
  formula,
  data = NULL,
  se_type = "HC3",
  se_type_missing = TRUE,
  dots = list(),
  calling_env = parent.frame()
)
}
\arguments{
\item{formula}{A formula specifying the model.}

\item{data}{An optional data frame containing the variables.}

\item{se_type}{The type of standard error to use.}

\item{se_type_missing}{Logical. Whether se_type was not explicitly provided by user.}

\item{dots}{Additional arguments passed to lm_robust (to check for clusters).}

\item{calling_env}{The environment in which to look for variables if data is not provided.}
}
\value{
A list containing:
\itemize{
  \item \code{data}: The data frame to use (either provided or constructed from vectors)
  \item \code{se_type}: The validated/adjusted se_type
  \item \code{has_clusters}: Logical indicating if clusters are being used
}
}
\description{
Validates se_type and clusters arguments for lm2().
Also handles creating a data frame from vectors if data is not provided.
}
\keyword{internal}
