% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.yule}
\alias{ci.yule}
\title{Confidence intervals for generalized Yule coefficients}
\usage{
ci.yule(alpha, f00, f01, f10, f11)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f00}{number of participants with y = 0 and x = 0}

\item{f01}{number of participants with y = 0 and x = 1}

\item{f10}{number of participants with y = 1 and x = 0}

\item{f11}{number of participants with y = 1 and x = 1}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of generalized Yule coefficient
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals for four generalized Yule measures of
association (Yule Q, Yule Y, Digby H, and Bonett-Price Y*) using a
transformation of a confidence interval for an odds ratio with .5 added to
each cell frequency. This function requires the frequency counts from a
2 x 2 contingency table for two dichotomous variables. Digby H is sometimes
used as a crude approximation to the tetrachoric correlation. Yule Y is
equal to the phi coefficient only when all marginal frequencies are equal.
Bonett-Price Y* is a better approximation to the phi coefficient when the
marginal frequencies are not equal.

For more details, see Section 3.4 of Bonett (2021, Volume 3)
}
\examples{
ci.yule(.05, 229, 28, 96, 24)

# Should return:
#    Estimate     SE    LL    UL
# Q:    0.343 0.1328 0.062 0.573
# Y:    0.177 0.0729 0.031 0.315
# H:    0.262 0.1051 0.047 0.454
# Y*:   0.131 0.0546 0.023 0.236


}
\references{
\insertRef{Bonett2021}{statpsych}
\insertRef{Bonett2007}{statpsych}
}
