% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.lc.prop.scheffe}
\alias{ci.lc.prop.scheffe}
\title{Scheffe confidence interval for a linear contrast of proportions in a
between-subjects design}
\usage{
ci.lc.prop.scheffe(alpha, f, n, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f}{vector of frequency counts of participants who have the attribute}

\item{n}{vector of sample sizes}

\item{v}{vector of between-subjects contrast coefficients}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - adjusted estimate of proportion linear contrast
\item SE - adjusted standard error
\item z - z test statistic
\item p - two-sided Scheffe p-value
\item LL - lower limit of the Scheffe confidence interval
\item UL - upper limit of the Scheffe confidence interval
}
}
\description{
Computes an adjusted Wald confidence interval for a linear contrast of
population proportions in a between-subjects design using a Scheffe
critical value. A Scheffe p-value is computed for the test statistic.
This function is useful in exploratory studies where the linear contrast
of proportions was not planned but was suggested by the pattern of sample
proportions. Use the \link[statpsych]{ci.lc.prop.bs} function with a
Bonferroni adjusted alpha value to compute simultaneous confidence
intervals for two or more planned linear contrasts of proportions.

For more details, see Section 2.9 of Bonett (2021, Volume 3)
}
\examples{
f <- c(26, 24, 38)
n <- c(60, 60, 60)
v <- c(-.5, -.5, 1)
ci.lc.prop.scheffe(.05, f, n, v)

# Should return:
#  Estimate         SE      z       p         LL        UL
# 0.2119565 0.07602892 2.7878 0.02053 0.02585698 0.3980561


}
\references{
\insertRef{Price2004}{statpsych}

\insertRef{Marascuilo1977}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
