/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.IntArray;
import vcf.Marker;
import vcf.VcfEmission;

public class SeqCodedRefGT
implements VcfEmission {
    private final Marker marker;
    private final Samples samples;
    private final IntArray hapToSeq;
    private final IntArray seqToAllele;

    public SeqCodedRefGT(Marker marker, Samples samples, IntArray intArray, IntArray intArray2) {
        SeqCodedRefGT.checkData(marker, samples, intArray, intArray2);
        this.marker = marker;
        this.samples = samples;
        this.hapToSeq = intArray;
        this.seqToAllele = intArray2;
    }

    private static void checkData(Marker marker, Samples samples, IntArray intArray, IntArray intArray2) {
        String string = "inconsistent data";
        int n = intArray.size();
        if (intArray.size() != 2 * samples.nSamples()) {
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < n; ++i) {
            marker.allele(intArray2.get(intArray.get(i)));
        }
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int nHaps() {
        return this.hapToSeq.size();
    }

    @Override
    public int nHapPairs() {
        return this.samples.nSamples();
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public boolean isRefData() {
        return true;
    }

    @Override
    public float gl(int n, int n2, int n3) {
        boolean bl = n2 == this.allele1(n) && n3 == this.allele2(n);
        return bl ? 1.0f : 0.0f;
    }

    @Override
    public boolean isPhased(int n) {
        return true;
    }

    @Override
    public int allele1(int n) {
        return this.seqToAllele.get(this.hapToSeq.get(2 * n));
    }

    @Override
    public int allele2(int n) {
        return this.seqToAllele.get(this.hapToSeq.get(2 * n + 1));
    }

    @Override
    public int allele(int n) {
        return this.seqToAllele.get(this.hapToSeq.get(n));
    }

    @Override
    public int nAlleles() {
        return this.marker().nAlleles();
    }

    @Override
    public boolean storesNonMajorIndices() {
        return false;
    }

    @Override
    public int majorAllele() {
        String string = "this.storesNonMajorIndices()==false";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public int alleleCount(int n) {
        String string = "this.storesNonMajorIndices()==false";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public int hapIndex(int n, int n2) {
        String string = "this.storesNonMajorIndices()==false";
        throw new UnsupportedOperationException(string);
    }

    public String toString() {
        return this.toVcfRec();
    }
}

