#' @title Codelist Age
#'
#' @description A dataset containing the \code{Age} codelist,
#' abbreviated as \code{CL_AGE}. Version 1.0.
#' @details The SDMX description: "This code list provides a set of building blocks
#' to be used for creating simple or complex code identifiers relating to the concept of
#' \code{age} as defined in the Cross-Domain Concepts and the Metadata Common Vocabulary,
#' i.e. the length of time that a person has lived or a thing has existed.
#' This code list was formally adopted on 7 February 2014."
#' @format A data frame with 5 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing age-related time concepts.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_AGE"

#' @title Reference Area Code List
#'
#' @description A dataset contains \code{Reference Area Code List},
#' abbreviated as \code{CL_AREA}. Version 2.0.
#' @details The SDMX description: 'Represents a combination of
#' reference area codes in the \[United Nations\] \href{https://unstats.un.org/unsd/methodology/m49/}{M49} and \href{https://www.iso.org/iso-3166-country-codes.html}{ISO-3166} classifications.'
#' @format A data frame with 899 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code lise for describing reference geographical areas.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code, with reference to the relevant international standard.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_AREA"

#' @title Codelist Activity - ISIC, Revision 4
#'
#' @description A dataset containing the \code{	Activity - ISIC, Revision 4} codelist,
#' abbreviated as \code{CL_ACTIVITY_ANZSIC06}. Version 1.0.
#' @details The SDMX description: "This code list provides lists of values for describing
#' the economic activity, defined as the combination of actions that result in the
#' production, distribution and consumption of goods or services. It is based on the
#' Australian/New Zealand standard classification ANZSIC (Australian and New Zealand
#' Standard Industrial Classification), 2006."
#' @format A data frame with 825 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing economic activities according to ANZSIC.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_ACTIVITY_ANZSIC06"

#' @title Codelist Activity - NACE, Revision 2
#'
#' @description A dataset containing the \code{Activity - NACE, Revision 2} codelist,
#' abbreviated as \code{CL_ACTIVITY_NACE2}. Version 1.0.
#' @details The SDMX description: 'This code list provides lists of values for describing the economic activity, defined as the combination of actions that result in the production, distribution and consumption of goods or services. It is based on the European Union standard classification NACE (Statistical Classification of Economic Activities in the European Community), Revision 2 (2008). More information about and
#' supporting material for this code list and SDMX code lists in general
#' (e.g. list of generic codes for expressing general concepts like "Total", "Unknown",
#' etc.; syntaxes for the creation of further codes; general guidelines for the creation
#' of SDMX code lists) can be found at this address: \url{https://sdmx.org/?page_id=4345}.'
#' @format A data frame with 996 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing economic activities according to NACE Rev.2.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_ACTIVITY_NACE2"

#' @title Codelist Activity - ISIC, Revision 4
#'
#' @description A dataset containing the \code{Activity - ISIC, Revision 4} codelist,
#' abbreviated as \code{CL_ACTIVITY_ISIC4}. Version 1.0.
#' @details The SDMX description: "This code list provides lists of values for describing
#' the economic activity, defined as the combination of actions that result in the
#' production, distribution and consumption of goods or services. It is based on the
#' United Nations standard classification ISIC (International Standard Industrial
#' Classification of All Economic Activities), Revision 4 (2008)."
#' @format A data frame with 766 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing economic activities.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_ACTIVITY_ISIC4"

#' @title Codelist Civil (or Marital) Status
#'
#' @description A dataset containing the \code{Civil (or Marital) Status} codelist,
#' abbreviated as \code{CL_CIVIL_STATUS}. Version 1.0.
#' @details The SDMX description: "This code list provides a list of values for describing
#' the civil (or marital) status of an individual, i.e. the legal, conjugal status of an individual in
#' relation to the marriage laws or customs of the country.
#' This code list was formally adopted on 25 November 2013."
#' @format A data frame with 8 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing the civil (marital) status of the individual.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_CIVIL_STATUS"

#' @title Classification of the Functions of Government
#'
#' @description A dataset containing the \code{Classification of the Functions of Government} codelist,
#' abbreviated as \code{CL_COFOG_1999}. Version 1.0.
#' @details The SDMX description: "This code list provides a set of building blocks
#' to be used for classifying final consumption expenditures of general government by
#' function or purpose. It is based on the United Nations eponymous standard classification.
#' This code list was formally adopted on 27 June 2014."
#' @format A data frame with 188 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing government functions.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_COFOG_1999"

#' @title Classification of the Purposes of Non-Profit Institutions Serving Households
#'
#' @description A dataset containing the \code{Classification of the Purposes of Non-Profit Institutions Serving Households} codelist,
#' abbreviated as \code{CL_COPNI_1999}. Version 1.0.
#' @format A data frame with 65 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing non-profit services for households.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_COPNI_1999"

#' @title Classification of the Outlays of Producers According to Purpose
#'
#' @description A dataset containing the \code{Classification of the Outlays of Producers According to Purpose} codelist,
#' abbreviated as \code{CL_COPP_1999}. Version 1.0.
#' @description SDMX desciption: "This code list provides a set of building blocks to be
#' used for classifying outlays of enterprises by purpose. It is based on the United Nations
#' eponymous standard classification. This code list was formally adopted on 27 June 2014."
#' @format A data frame with 51 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing outlays to producers.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_COPP_1999"

#' @title Codelist Confidentiality Status
#'
#' @description A dataset containing the \code{Confidentiality Status} codelist,
#' abbreviated as \code{CL_CONF_STATUS}. Version 1.2.
#' @details Metadata for describing the confidentiality of a statistical product, from
#' \code{Free (free for publication)} till \code{Not for publication, restricted for internal use only}.
#' @format A data frame with 11 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing the confidentiality status of a statistical product.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_CONF_STATUS"

#' @title Codelist Decimals
#'
#' @description A dataset containing the \code{Decimals} codelist,
#' abbreviated as \code{CL_DECIMALS}. Version 1.0.
#' @details This code list provides a list of values showing the number of decimal
#' digits used in the data. This code list was released in 2009.
#' @format A data frame with 16 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing the number of decimals.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_DECIMALS"

#' @title Codelist Degree of Urbanization
#'
#' @description A dataset containing the \code{Degree of Urbanization} codelist,
#' abbreviated as \code{CL_DEG_URB}. Version 1.0.
#' @details The SDMX description: "This code list provides coded information about
#' the degree to which area is urbanised."
#' @format A data frame with 14 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing degrees of urbanizations.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_DEG_URB"

#' @title Codelist Frequency
#'
#' @description Codelist \code{Frequency}, abbreviated as \code{CL_FREQ}. Version 2.1.
#' @details The SDMX description: 'This code list provides a set of values indicating the
#'\code{frequency} of the data (e.g. weekly, monthly, quarterly). The concept\code{frequency}
#' may refer to various stages in the production process, e.g. data collection or data
#' dissemination. For example, a time series could be disseminated at annual frequency but
#' the underlying data are compiled monthly. The code list is applicable for all different
#' uses of\code{frequency}.'
#' @format A data frame with 34 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing data collection frequency.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_FREQ"

#' @title Codelist Observation status
#'
#' @description A dataset containing the \code{Observation Status} codelist,
#' abbreviated as \code{CL_OBS_STATUS}. Version 2.2.
#' @details The SDMX description: "This code list provides coded information about the
#' "status" of an observation (with respect to events such as the ones reflected in the
#' codes composing the code list). The observation status provides information on
#' 1) the quality of a value or 2) unusual or missing values."
#' @format A data frame with 20 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing data observation status.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_OBS_STATUS"

#' @title Codelist Occupation
#'
#' @description A dataset containing the \code{Occupation} codelist,
#' abbreviated as \code{CL_OCCUPATION}. Version 2.2.
#' @details The SDMX description: "This code list provides a list of values for
#' describing the job or position held by an individual."
#' @format A data frame with 619 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing occupations.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_OCCUPATION"

#' @title Codelist Seasonal Adjustment
#'
#' @description Codelist \code{Seasonal Adjustment}, abbreviated \code{CL_SEASONAL_ADJUST} Version 1.0
#' @details The SDMX description: 'Seasonal adjustment is a statistical technique used to
#' remove the effects of seasonal and calendar influences operating on a data series.
#' Version 1.0 of the code list was formally adopted by the SDMX Secretariat on 4 July 2014.
#' '
#' @format A data frame with 11 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing seasonal adjustments.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_SEASONAL_ADJUST"

#' @title Codelist Sex
#'
#' @description Codelist \code{Sex}, Version 2.1.
#' @details The SDMX description: "This code list provides coded information
#' about the state of being male or female.
#' This concept is applied if data needs to be categorised by sex.
#' It applies not only to human beings but also to animals and other living organisms."
#' @format A data frame with 7 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing sex.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_SEX"

#' @title Codelist Time Format
#'
#' @description Codelist \code{Time Format}, abbreviated as \code{CL_TIME_FORMAT}. Version 1.0.
#' @details The SDMX description: 'This code list provides coded information (based on the ISO 8601 standard)
#' indicating the type of time references used in the data. It was released in 2009. More information about this
#' code list and SDMX code lists in general (e.g. list of generic codes for expressing general concepts like "Total",
#' "Unknown", etc.; syntaxes for the creation of further codes; general guidelines for the creation of SDMX code
#' lists) can be found at this address: \url{https://sdmx.org/?page_id=4345}.'
#' @format A data frame with 21 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing the various time formats.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_TIME_FORMAT"

#' @title Codelist Time Period - Collection
#'
#' @description Codelist \code{Time Period - Collection},
#' abbreviated as \code{CL_TIME_PER_COLLECT}. Version 1.0.
#' @details The SDMX description: "This code list provides a list of values for representing
#' dates or periods during which the observations have been collected in order to compile
#' the indicator for the target reference period. This code list was formally adopted on
#' 15 April 2015."
#' @format A data frame with 8 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing the collection method within a time frame.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_TIME_PER_COLLECT"

#' @title Codelist Time Transformation
#'
#' @description Codelist \code{Time Transformation}, abbreviated as
#' \code{CL_TIMETRANS}. Version 1.0.
#' @details The SDMX description: "Code list for compound coding (type and period)
#' of transformation types of time series."
#' @format A data frame with 47 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing the transformation types of time series.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_TIMETRANS"

#' @title Codelist Time Transformation Period
#'
#' @description Codelist \code{Time Transformation Period}, abbreviated as
#' \code{CL_TIMETRANS_PER}. Version 1.0.
#' @details The SDMX description: "	Code list for information about the number
#' of periods used for a time-related transformation of the time series."
#' @format A data frame with 12 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing the transformation periods of time series.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_TIMETRANS_PER"

#' @title Codelist Time Transformation Type
#'
#' @description Codelist \code{Time Transformation Type}, abbreviated as \code{CL_TIMETRANS_TYPE}. Version 1.0.
#' @details The SDMX description: "Code list for time-related transformation types of time series."
#' @format A data frame with 13 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing the transformation types of time series.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_TIMETRANS_TYPE"

#' @title Codelist Unit multiplier
#'
#' @description Codelist \code{Unit multiplier}, abbreviated as \code{CL_UNIT_MULT}. Version 1.1.
#' @details The SDMX description: "This code list provides code values for indicating the
#' magnitude in the units of measurement. More information about this code list and SDMX
#' code lists in general (e.g. list of generic codes for expressing general concepts like
#' "Total", "Unknown", etc.; syntaxes for the creation of further codes; general guidelines
#' for the creation of SDMX code lists) can be found at this address:
#' \url{https://sdmx.org/?page_id=4345}."
#' @format A data frame with 31 rows and 5 variables:
#' \describe{
#'   \item{id}{A statistical code for describing unit multipliers.}
#'   \item{name}{The standard label of the code.}
#'   \item{description}{The description of the code.}
#'   \item{name_locale}{The language code of the name label.}
#'   \item{description_locale}{The language code of the description.}
#' }
#' @source \url{https://sdmx.org/?page_id=3215/}
"CL_UNIT_MULT"
