% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_schema_filter_fact_rows.R
\name{filter_fact_rows}
\alias{filter_fact_rows}
\alias{filter_fact_rows.star_schema}
\title{Filter fact rows}
\usage{
filter_fact_rows(st, name = NULL, ...)

\method{filter_fact_rows}{star_schema}(st, name = NULL, ...)
}
\arguments{
\item{st}{A \code{star_schema} object.}

\item{name}{A string, name of the dimension.}

\item{...}{Conditions, defined in exactly the same way as in \code{dplyr::filter}.}
}
\value{
A \code{star_schema} object.
}
\description{
Filter fact rows based on dimension conditions in a star schema. Dimensions
remain unchanged.
}
\details{
Filtered rows can be deleted using the \code{incremental_refresh_star_schema}
function.
}
\examples{

st <- st_mrs_age |>
  filter_fact_rows(name = "when", week <= "03") |>
  filter_fact_rows(name = "where", city == "Bridgeport")

st2 <- st_mrs_age |>
  incremental_refresh_star_schema(st, existing = "delete")

}
\seealso{
Other incremental refresh functions: 
\code{\link{get_star_schema}()},
\code{\link{get_star_schema_names}()},
\code{\link{incremental_refresh_constellation}()},
\code{\link{incremental_refresh_star_schema}()},
\code{\link{purge_dimensions_constellation}()},
\code{\link{purge_dimensions_star_schema}()}
}
\concept{incremental refresh functions}
