% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{stanza_download}
\alias{stanza_download}
\title{Download Models}
\usage{
stanza_download(
  language = "en",
  model_dir = stanza_options("model_dir"),
  package = "default",
  processors = list(),
  logging_level = "INFO",
  resources_url = stanza_options("resources_url"),
  resources_version = stanza_options("resources_version"),
  model_url = stanza_options("model_url")
)
}
\arguments{
\item{language}{a character string giving the language (default is \code{"en"}).}

\item{model_dir}{path to the directory for storing the for \code{Stanza} models
(default is \code{"~/stanza_resources"}).}

\item{package}{a character string giving the package to be used (default is \code{"default"}.
In this context package refers to a language specific set of models packaged
together to a single \code{".zip"} file.}

\item{processors}{a character string or named list giving the processors to download models for.
If a string is provided it should provide the names of the desired processers as comma seperated
string, e.g., \code{"tokenize,pos"}.
If a named list is provided, the name should be the processor name and the values the
package name, e.g., \code{list(tokenize = "ewt", pos = "ewt")}.}

\item{logging_level}{a character string giving the logging level (default is \code{"INFO"}),
available levels are \code{c('DEBUG', 'INFO', 'WARNING', 'WARN', 'ERROR', 'CRITICAL', 'FATAL')}.}

\item{resources_url}{a character string giving the url to the \code{Stanza} model resources.
The default value is obtained from Python during the initiatlization and can be obtained
and changed by using \code{stanza_options}.}

\item{resources_version}{a character string giving the version of the resources.
The default value is obtained from Python during the initiatlization and can be obtained
and changed by using \code{stanza_options}.}

\item{model_url}{a character string giving the model url.
The default value is obtained from Python during the initiatlization and can be obtained
and changed by using \code{stanza_options}.}
}
\value{
\code{NULL}
}
\description{
Download pretrained NLP models. For more information about the parameters
see \url{https://stanfordnlp.github.io/stanza/download_models.html}.
}
\examples{
if (stanza_options("testing_level") >= 3L) {
stanza_initialize()
stanza_download("en")
}
}
