% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slp_info.R
\name{slp_info}
\alias{slp_info}
\title{Retrieve information on standard load profiles}
\source{
\url{https://www.bdew.de/energie/standardlastprofile-strom/}

\url{https://www.bdew.de/media/documents/2000131_Anwendung-repraesentativen_Lastprofile-Step-by-step.pdf}

\url{https://www.bdew.de/media/documents/Zuordnung_der_VDEW-Lastprofile_zum_Kundengruppenschluessel.pdf}
}
\usage{
slp_info(profile_id, language = c("EN", "DE"))
}
\arguments{
\item{profile_id}{load profile identifier, required}

\item{language}{one of 'EN' (English), 'DE' (German)}
}
\value{
A list
}
\description{
Information and examples on standard load profiles from the
German Association of Energy and Water Industries (BDEW
Bundesverband der Energie- und Wasserwirtschaft e.V.)
}
\examples{
slp_info("G5", language = "DE")

# multiple profile IDs are supported
slp_info(c("G0", "G5"))
}
