% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_cut.R
\name{quantile_cut}
\alias{quantile_cut}
\title{MOVED Easy function for splitting numeric variable in quantiles}
\usage{
quantile_cut(
  x,
  groups,
  y = NULL,
  na.rm = TRUE,
  group.names = NULL,
  ordered.f = FALSE,
  inc.outs = FALSE,
  detail.list = FALSE
)
}
\arguments{
\item{x}{Variable to cut.}

\item{groups}{Number of groups.}

\item{y}{alternative vector to draw quantile cuts from. Limits has
to be within x. Default is NULL.}

\item{na.rm}{Remove NA's. Default is TRUE.}

\item{group.names}{Names of groups to split to. Default is NULL,
giving intervals as names.}

\item{ordered.f}{Set resulting vector as ordered. Default is FALSE.}

\item{inc.outs}{Flag to include min(x) and max(x)
as borders in case of y!=NULL.}

\item{detail.list}{flag to include details or not}
}
\value{
vector or list with vector and details (length 2)
}
\description{
Using base/stats functions cut() and quantile().
}
\examples{
aa <- as.numeric(sample(1:1000,2000,replace = TRUE))
x <- 1:450
y <- 6:750
summary(quantile_cut(aa,groups=4,detail.list=FALSE)) ## Cuts quartiles
}
\keyword{quantile}
