% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_plotting.R
\name{generate_CEG_map}
\alias{generate_CEG_map}
\title{Generate a Leaflet Map for a Chain Event Graph (CEG)}
\usage{
generate_CEG_map(
  shapefile,
  ceg_object,
  conditionals = unique(ceg_object$x$edges$label1),
  colour_by = NULL,
  color_palette = "viridis"
)
}
\arguments{
\item{shapefile}{A Simple Features (sf) object representing the shapefile data for the geographical areas.}

\item{ceg_object}{A list containing the Chain Event Graph (CEG) data, including nodes and edges.}

\item{conditionals}{A character vector containing the conditions (labels) to condition on when calculating
area probabilities. Default is the unique edge labels from the \code{ceg_object}.}

\item{colour_by}{A string specifying the label by which to color the map. Default is \code{NULL}, which colors by
the label with the maximum level.}

\item{color_palette}{A string specifying the color palette to use for the map. Default is "viridis".}
}
\value{
A Leaflet map object with color-coded polygons representing the areas, with a legend indicating
the probability values for each area.
}
\description{
This function generates an interactive map using the Leaflet package to visualize the probability of each
area in the Chain Event Graph (CEG). The map is color-coded based on area-specific probabilities, which
are calculated from the path products and conditional probabilities.
}
\examples{
data <- homicides
event_tree <- create_event_tree(data, columns = c(9,2,4,5), "both")
coloured_tree <- ahc_colouring(event_tree)

tree_priors <- specify_priors(coloured_tree, prior_type = "Uniform", ask_edit = FALSE)
staged_tree <- staged_tree_prior(coloured_tree, tree_priors)
ceg <- create_ceg(staged_tree, view_table = TRUE)
generate_CEG_map(bcu_shapefile, ceg)

}
