% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_reduced_CEG.R
\name{create_reduced_CEG}
\alias{create_reduced_CEG}
\title{Create a Reduced Chain Event Graph (CEG)}
\usage{
create_reduced_CEG(
  ceg_object,
  start_labels,
  level_separation = 1200,
  node_distance = 300
)
}
\arguments{
\item{ceg_object}{A list containing the Chain Event Graph (CEG) data, including nodes and edges.
The \code{ceg_object} must have the structure \code{ceg_object$ceg$x$nodes} and \code{ceg_object$ceg$x$edges}.}

\item{start_labels}{A character vector containing the labels of the nodes from which the floret extraction should start.}

\item{level_separation}{A numeric value determining the separation between levels in the hierarchical layout. Default is 1200.}

\item{node_distance}{A numeric value controlling the distance between nodes in the hierarchical layout. Default is 300.}
}
\value{
A visNetwork object representing the reduced CEG, with interactive visualization features,
such as node selection, highlighting of edges, and layout manipulation.
}
\description{
This function generates a reduced version of a Chain Event Graph (CEG) based on a set of starting labels.
It extracts connected nodes and edges from the input CEG object, and visualizes the result using the visNetwork package.
}
\examples{
data <- homicides
event_tree <- create_event_tree(data, columns = c(1,2,4,5), "both")
coloured_tree <- ahc_colouring(event_tree)

tree_priors <- specify_priors(coloured_tree, prior_type = "Uniform", ask_edit = FALSE)
staged_tree <- staged_tree_prior(coloured_tree, tree_priors)
ceg <- create_ceg(staged_tree, view_table = TRUE)
create_reduced_CEG(ceg, "Adult")


}
