% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_event_tree.R
\name{create_event_tree}
\alias{create_event_tree}
\title{Create an Event Tree from a Dataset}
\usage{
create_event_tree(
  dataset,
  columns = seq_along(dataset),
  label_type = "both",
  level_separation = 1000,
  node_distance = 300
)
}
\arguments{
\item{dataset}{A data frame containing categorical variables.}

\item{columns}{A vector of column indices or names specifying which variables to use for constructing the event tree.}

\item{label_type}{A character string specifying how edge labels should be displayed. Options are \code{"names"} (variable names),
\code{"both"} (variable names and counts). Default is \code{"both"}.}

\item{level_separation}{A numeric value indicating the spacing between levels in the visualization. Default is \code{1000}.}

\item{node_distance}{A numeric value specifying the horizontal distance between nodes in the visualization. Default is \code{300}.}
}
\value{
A \code{visNetwork} object displaying the event tree.
}
\description{
This function constructs an event tree from a given dataset based on user-specified categorical variables.
The resulting tree is represented as a graph, where each unique combination of variable values corresponds
to a distinct path in the tree.
}
\details{
The function follows these steps:
\enumerate{
\item Extracts the specified columns from the dataset.
\item Determines unique values for each variable and generates state names dynamically.
\item Constructs a directed acyclic graph (DAG) using \code{igraph}, where each state represents a unique combination of variable values.
\item Computes transition counts between states.
\item Uses \code{visNetwork} to generate an interactive visualization of the event tree.
}
}
\examples{
data <- homicides
event_tree <- create_event_tree(data, columns = c(1,2,4,5), "both")
event_tree
}
