% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_plotting.R
\name{calculate_path_products}
\alias{calculate_path_products}
\title{Calculate Path Products in a Chain Event Graph (CEG)}
\usage{
calculate_path_products(nodes_df, edges_df, root_node = "w0")
}
\arguments{
\item{nodes_df}{A data frame representing the nodes in the CEG.}

\item{edges_df}{A data frame representing the edges in the CEG, containing columns for \code{from}, \code{to},
\code{label1}, and \code{posterior_mean}.}

\item{root_node}{A string specifying the label of the root node from which to start the traversal. Default is "w0".}
}
\value{
A data frame with two columns:
\item{path}{The sequence of nodes in the path, as a string of node labels separated by " -> "}
\item{product}{The product of the posterior means along the path}
}
\description{
This function calculates the products of probabilities along all paths from a specified root node
in a Chain Event Graph (CEG). It traverses the graph, multiplying the posterior means of the edges
for each path, and returns the resulting paths and their products.
}
