% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/borough_shapefile.R
\docType{data}
\name{borough_shapefile}
\alias{borough_shapefile}
\title{London Borough Boundaries}
\format{
A \code{sf} object with 33 features and 1 field:
\describe{
\item{Borough}{Name of the London Borough (character)}
\item{geometry}{MULTIPOLYGON geometry column in BNG projection}
}
}
\source{
London Datastore
}
\usage{
borough_shapefile
}
\description{
A  \code{sf} object containing the spatial boundaries of London boroughs,
projected in the British National Grid (EPSG:27700). This dataset includes the borough
names and associated MULTIPOLYGON geometries.
}
\examples{
library(sf)
plot(st_geometry(borough_shapefile))

}
\keyword{datasets}
\keyword{sf}
\keyword{spatial}
