% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssMRCD_methods.R
\name{scale.ssMRCD}
\alias{scale.ssMRCD}
\title{Locally Center and/or Scale or Data Using an ssMRCD Object}
\usage{
\method{scale}{ssMRCD}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"ssMRCD"}. See \code{\link[ssMRCD]{ssMRCD}}.}

\item{...}{List of additional arguments including:
\describe{
  \item{\code{X}}{A numeric matrix or data frame containing new observations to be scaled. If not provided, the data stored in the \code{ssMRCD} object is used.}
  \item{\code{groups}}{An integer vector from 1 to number of groups of group assignments corresponding
   to the rows of \code{X}. If \code{X} is not provided, defaults to the group
   assignments used in the original ssMRCD estimation.}
  \item{\code{center_only}}{Logical. If \code{TRUE}, only centering is
  applied; if \code{FALSE}, both centering and scaling are applied.
  Default is \code{FALSE}.}
}}
}
\value{
A numeric matrix of the same dimension as \code{X}, where each observation has
been standardized (or centered) using the corresponding group-wise robust mean and
(if applicable) variance from the ssMRCD model.
If \code{X = NULL}, the original data from the ssMRCD object is returned in scaled form,
sorted according to group labels.
}
\description{
Applies local standardization (scaling and/or centering) of either the original data
from an \code{ssMRCD} object or new data provided via the \code{X} argument,
using group-wise robust means and variances from the ssMRCD estimation.
}
\details{
For each group, the function applies scaling (or just centering) using the robust
location and scale (square root of the diagonal of the covariance) estimates obtained
during ssMRCD estimation.
}
\examples{
# Simulated example
x1 <- matrix(runif(200), ncol = 2)
x2 <- matrix(rnorm(200), ncol = 2)
x <- list(x1, x2)

W <- matrix(c(0, 1, 1, 0), ncol = 2)
localCovs <- ssMRCD(x, weights = W, lambda = 0.5)

# Scale original data
sc = scale(localCovs)

# Scale new observations
sc = scale(localCovs,
           list(X = matrix(rnorm(20), ncol = 2, nrow = 10),
           groups = rep(2, 10)))

# Center only
sc = scale(localCovs,
           list(X = matrix(rnorm(20), ncol = 2, nrow = 10),
           groups = rep(2, 10),
           center_only = TRUE))

}
\seealso{
\code{\link[ssMRCD]{ssMRCD}}
}
