% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locOuts.R
\name{plot.locOuts}
\alias{plot.locOuts}
\title{Diagnostic Plots for Local Outlier Detection (`locOuts`)}
\usage{
\method{plot}{locOuts}(
  x,
  type = c("hist", "spatial", "pcp"),
  scale = c("none", "minmax", "zscore"),
  bins = 30,
  observation = 1,
  ...
)
}
\arguments{
\item{x}{An object of class \code{"locOuts"} obtained from \code{\link[ssMRCD]{locOuts}}.}

\item{type}{A character vector indicating which plots to generate. Options are:
\describe{
  \item{"hist"}{Histogram of next distances with cutoff visualized.}
  \item{"spatial"}{Spatial distribution of observations, colored by relative next distance.}
  \item{"pcp"}{Parallel coordinate plot for an observation and its neighbors.}
}}

\item{scale}{Character indicating how variables are scaled in the parallel coordinate plot. One of:
\describe{
  \item{"none"}{Use raw values (no scaling).}
  \item{"minmax"}{Min-max scaling to [0, 1].}
  \item{"zscore"}{Standardization: mean 0, standard deviation 1.}
}}

\item{bins}{Integer, number of histogram bins (default = 30).}

\item{observation}{Integer or character; index or name of a specific observation to analyze in the PCP plot.
Used only when \code{type} includes \code{"pcp"}.}

\item{...}{Additional parameters passed to low-level plotting functions (currently unused in ggplot versions).}
}
\value{
A named list with elements:
  \describe{
    \item{\code{p_hist}}{ggplot object of the histogram (or \code{NULL} if not requested).}
    \item{\code{p_spatial}}{ggplot object of the spatial plot (or \code{NULL}).}
    \item{\code{p_pcp}}{ggplot object of the parallel coordinate plot (or \code{NULL}).}
  }
}
\description{
Produces diagnostic plots for local outlier detection results
returned by \code{\link[ssMRCD]{locOuts}}.
Available visualizations include a histogram of next distances, spatial distribution of next distances,
and a parallel coordinate plot (PCP) for a selected observation and their neighborhood.
}
\details{
The function visualizes outlier behavior in different ways:
\itemize{
  \item \strong{Histogram}: Shows the distribution of next distances across observations. The cutoff is shown as a dashed line.
  \item \strong{Spatial Plot}: 2D plot of observation coordinates. Color encodes the ratio of next distance to cutoff.
  \item \strong{Parallel Coordinate Plot (PCP)}: Shows scaled values across all variables for a selected observation
    (in red) and its neighbors (in blue or grey). The type of scaling can be controlled via the \code{scale} parameter.
}
}
\examples{
set.seed(1)
data <- matrix(rnorm(2000), ncol = 4)
coords <- matrix(rnorm(1000), ncol = 2)
groups <- sample(1:10, 500, replace = TRUE)
outs <- locOuts(data = data,
                coords = coords,
                groups = groups,
                lambda = 0.3,
                k = 10)

# Generate all plots
plots <- plot(outs,
              type = c("hist", "spatial", "pcp"),
              observation = outs$outliers[1],
              scale = "minmax")
plots$p_hist
plots$p_spatial
plots$p_pcp
}
\seealso{
\code{\link[ssMRCD]{locOuts}}
}
