% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRPCAMS.R
\name{msPCA}
\alias{msPCA}
\title{Compute Sparse Multi-Source Principal Components}
\usage{
msPCA(
  eta,
  gamma,
  COVS,
  k = ncol(COVS[[1]]),
  adjust_eta = TRUE,
  convergence_plot = FALSE,
  n_max = 200,
  rho = list(NA, TRUE, 100, 1),
  eps = c(1e-05, 1e-04, 0.1, 50),
  show_progress = FALSE
)
}
\arguments{
\item{eta}{Numeric or numeric vector. Controls the overall sparsity level. If a single value is provided, it will be used directly.
If a vector is given, the optimal value will be selected via internal model selection.}

\item{gamma}{Numeric or numeric vector. Controls the distribution of sparsity across components.
If a single value is provided, the optimal \code{eta} is selected automatically.}

\item{COVS}{A list of covariance or correlation matrices (one per data source or group).}

\item{k}{Integer. Number of principal components to compute. If not specified, all components are estimated.}

\item{adjust_eta}{Logical. If \code{TRUE} (default), the sparsity parameter \code{eta} is adjusted based on the variance structure.}

\item{convergence_plot}{Logical. If \code{TRUE}, a convergence diagnostic plot is displayed of either the residuals or the loading entries (default: \code{FALSE}).}

\item{n_max}{Integer. Maximum number of ADMM iterations (default: 200).}

\item{rho}{List of parameters controlling the ADMM penalty parameter \code{rho}, with the following elements:
\describe{
  \item{1}{Initial value for \code{rho} (default: \code{NA}).}
  \item{2}{Logical; whether to increase \code{rho} if convergence is not reached (default: \code{TRUE}).}
  \item{3}{Maximum value for \code{rho} (default: 100). You may need to increase this for high-dimensional problems.}
  \item{4}{Step size for increasing \code{rho} (default: 1).}
}}

\item{eps}{Numeric vector of tolerance parameters used in optimization. Includes:
\describe{
  \item{1}{Tolerance for soft-thresholding (default: \code{1e-5}).}
  \item{2}{Tolerance for ADMM convergence (default: \code{1e-4}).}
  \item{3}{Tolerance for convergence of the internal root-finding step (default: \code{1e-1}).}
  \item{4}{Maximum number of iterations for the root finder (default: 50).}
}}

\item{show_progress}{Logical. Indicates whether progress bars should be displayed.}
}
\value{
An object of class \code{"msPCA"} containing the following elements:\tabular{ll}{
   \code{PC} \tab Array of dimension p x k x N of loading vectors.  \cr
   \tab \cr
   \code{p} \tab Number of variables. \cr
   \tab \cr
   \code{N} \tab Number of neighborhoods. \cr
   \tab \cr
   \code{k} \tab Number of components. \cr
   \tab \cr
   \code{COVS} \tab List of covariance matrices sorted by neighborhood. \cr
   \tab \cr
   \code{gamma} \tab Sparsity distribution. \cr
   \tab \cr
   \code{eta} \tab Amount of sparsity. \cr
   \tab \cr
   \code{converged} \tab Logical, if ADMM converged with given specifications. \cr
   \tab \cr
   \code{n_steps} \tab Number of steps used. \cr
   \tab \cr
   \code{residuals} \tab Primary and secondary residuals. \cr
   \tab \cr
}
}
\description{
Estimates sparse principal components from multiple covariance or correlation matrices
using an ADMM-based optimization routine (see Puchhammer, Wilms and Filzmoser, 2024).
}
\examples{

C1 = diag(c(1.1, 0.9, 0.6, 0.5, 2))
C2 = matrix(runif(25, -1, 1), 5, 5)
C2 = t(C2) \%*\% C2
C3 = matrix(runif(25, -1, 1), 5, 5)
C3 = t(C3) \%*\% C3

pca1 = msPCA(eta = 1, gamma = 0.5, COVS = list(C1, C2, C3), k = 3,
             n_max = 100, rho = list(NA, TRUE, 100, 1), show_progress = FALSE)
summary(pca1)

pca2 = msPCA(eta = seq(0, 3, 0.25), gamma = 1, COVS = list(C1, C2, C3), k = 3,
             n_max = 100, rho = list(NA, TRUE, 100, 1), show_progress = FALSE)
summary(pca2)
}
\references{
Puchhammer, P., Wilms, I., & Filzmoser, P. (2024). Sparse outlier-robust PCA for multi-source data. *ArXiv Preprint*.  \doi{10.48550/arXiv.2407.16299}
}
\seealso{
\code{\link[ssMRCD]{ssMRCD}},  \code{\link[ssMRCD]{plot.msPCA}},
\code{\link[ssMRCD]{summary.msPCA}}, \code{\link[ssMRCD]{biplot.msPCA}},
\code{\link[ssMRCD]{screeplot.msPCA}}, \code{\link[ssMRCD]{scores}}, \code{\link[ssMRCD]{align}}
}
