% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest_dfs_within_list_of_fully_named_lists.R
\name{unnest_dfs_within_list_of_fully_named_lists}
\alias{unnest_dfs_within_list_of_fully_named_lists}
\title{Unnest data.frames within fully named list}
\usage{
unnest_dfs_within_list_of_fully_named_lists(
  x,
  returned_name_when_dfs_are_not_nested = "data",
  ...
)
}
\arguments{
\item{x}{A list of fully named lists (which then contain data.frames)}

\item{returned_name_when_dfs_are_not_nested}{When x is a single list of data.frames, what name should be returned?}

\item{...}{parameters passed to data.table::rbindlist}
}
\value{
Fully named list, each element containing a data.table.
}
\description{
Consider the situation where a function returns a list containing two data.frames.
If this function is called repeatedly and the return values are stored in a list,
we will have a list of fully named lists (each of which contains a data.frame).
Typically, we want to extract the two data.frames from this nested list structure (and rbindlist them).
}
\examples{
x <- list(
  list(
    "a" = data.frame("v1"=1),
    "b" = data.frame("v2"=3)
  ),
  list(
    "a" = data.frame("v1"=10),
    "b" = data.frame("v2"=30),
    "d" = data.frame("v3"=50)
  ),
  list(
    "a" = NULL
  ),
  NULL
)
print(x)
splutil::unnest_dfs_within_list_of_fully_named_lists(x)

x <- list(
  data.frame("v1"=1),
  data.frame("v3"=50)
)
print(x)
splutil::unnest_dfs_within_list_of_fully_named_lists(
  x,
  returned_name_when_dfs_are_not_nested = "NAME",
  fill = TRUE
)
}
