\name{MISE.envelope}
\alias{MISE.envelope}
\alias{ISB.envelope}
\alias{IV.envelope}
\title{Mean Integrated Squared Error on an Envelope Object}
\description{
  Compute the mean integrated squared error,
  or integrated squared bias, or integrated variance,
  of the simulated function estimates in an envelope object.
}
\usage{
ISB.envelope(object, theo, domain, dimension=2)
IV.envelope(object, domain, dimension=2)
MISE.envelope(object, theo, domain, dimension=2)
}
\arguments{
  \item{object}{
    Object of class \code{"envelope"}
    generated by the function \code{\link[spatstat.explore]{envelope}}
  }
  \item{theo}{
    Function in the \R language that evaluates the
    true (theoretically expected) value of the
    spatial summary function. 
  }
  \item{domain}{
    Numeric vector of length 2 specifying the limits of the
    domain of integration for the integrated squared error.
  }
  \item{dimension}{
    Integer (either 1 or 2) specifying whether to calculate the
    one-dimensional or two-dimensional integral of squared error.
  }
}
\details{
  The first argument should be an object of class \code{"envelope"} 
  and should contain the simulated function estimates (i.e. it should
  have been computed using \code{\link[spatstat.explore]{envelope}}
  with \code{savefuns=TRUE}).

  \code{MISE.envelope} computes the mean integrated squared error.
  \code{ISB.envelope} computes the integrated squared bias.
  \code{IV.envelope} computes the integrated sample variance.

  The simulated function estimates are extracted from \code{object}
  and their deviation from the true function \code{theo}
  is computed pointwise. The squared deviations are integrated over the
  interval specified by \code{domain}, giving one value of integrated
  squared error for each simulated function estimate. Then
  \code{MISE.envelope} returns the average of these values, that is,
  the estimated mean squared error. Similarly for the other computations.
}
\value{
  A single numeric value.
}
\examples{
  E <- envelope(cells, Kest, nsim=20, savefuns=TRUE)
  theoK <- function(r) { pi * r^2 }
  dom <- c(0, 0.1)
  MISE.envelope(E, theoK, dom)
  ISB.envelope(E, theoK, dom)
}
\seealso{
  \code{\link{bias.envelope}},
  \code{\link{ISE.envelope}}.
}
\author{\adrian, \martinH and \tilman.}
\keyword{spatial}
\keyword{iteration}
