% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects_size.R
\name{objects_size}
\alias{objects_size}
\title{Display sizes of objects in current R environment}
\usage{
objects_size(n = 10)
}
\arguments{
\item{n}{Integer specifying the number of largest objects to display. Default: \code{10}.}
}
\value{
Data frame with object names as row names and four columns:
\itemize{
\item \code{Type}: Object class (e.g., "data.frame", "matrix", "list").
\item \code{Size}: Memory size with automatic unit formatting (e.g., "1.2 Mb", "500 bytes").
\item \code{Length/Rows}: Number of elements (for vectors) or rows (for data frames/matrices).
\item \code{Columns}: Number of columns (for data frames/matrices; \code{NA} for vectors and other objects).
}
}
\description{
Returns a summary of objects in the current R workspace, sorted from largest to smallest by memory size. Useful for identifying memory-intensive objects and diagnosing memory issues.
}
\details{
This utility function helps monitor memory usage by displaying the largest objects in your workspace. It's particularly useful for:
\itemize{
\item Identifying memory bottlenecks during large spatial analyses
\item Deciding which objects to remove to free memory
\item Understanding the memory footprint of different data structures
}

The function examines all objects in the global environment (\code{.GlobalEnv}) and calculates their memory usage using \code{\link[utils:object.size]{utils::object.size()}}. Objects are automatically sorted by size in descending order.
}
\examples{
# Create some objects of different sizes
small_vector <- runif(100)
medium_matrix <- matrix(runif(10000), 100, 100)
large_matrix <- matrix(runif(100000), 1000, 100)

# View the 5 largest objects
objects_size(n = 5)

# Check all objects (up to 10 by default)
objects_size()

}
\seealso{
\code{\link[utils:object.size]{utils::object.size()}}, \code{\link[base:ls]{base::ls()}}, \code{\link[base:rm]{base::rm()}}

Other utilities: 
\code{\link{.vif_to_df}()},
\code{\link{auc}()},
\code{\link{beowulf_cluster}()},
\code{\link{optimization_function}()},
\code{\link{prepare_importance_spatial}()},
\code{\link{rescale_vector}()},
\code{\link{root_mean_squared_error}()},
\code{\link{setup_parallel_execution}()},
\code{\link{standard_error}()},
\code{\link{statistical_mode}()},
\code{\link{thinning}()},
\code{\link{thinning_til_n}()}
}
\concept{utilities}
