% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.nb.gf.r
\name{fit.nb.gf}
\alias{fit.nb.gf}
\title{Fitting Longitudinal Data from a Gamma Frailty Model with Frailty of Autoregressive Correlation Structure of Order One}
\source{
\code{fit.nb.gf} uses code contributed by Thomas Asendorf.
}
\usage{
fit.nb.gf(
  dataC,
  dataE,
  trend = c("constant", "exponential"),
  lower,
  upper,
  method = "L-BFGS-B",
  start,
  approx = 20,
  rho = FALSE,
  H0 = FALSE,
  h0 = 0
)
}
\arguments{
\item{dataC}{a matrix containing count data from the control group, which is to be fitted. Columns correspond to time points, rows to observations.}

\item{dataE}{a matrix containing count data from the experiment group, which is to be fitted. Columns correspond to time points, rows to observations.}

\item{trend}{the trend which assumed to underlying in the data.}

\item{lower}{vector of lower bounds for estimated parameters \code{lambda}, \code{size} and \code{rho}, respectively.}

\item{upper}{vector of upper bounds for estimated parameters \code{lambda}, \code{size} and \code{rho}, respectively.}

\item{method}{algorithm used for minimization of the likelihood, see \code{\link{optim}} for details.}

\item{start}{vector of starting values for estimated parameters \code{mu}, \code{size} and \code{rho}, respectively, used for optimization.}

\item{approx}{numer of iterations in numerical calculation of the sandwich estimator, see 'Details'.}

\item{rho}{indicates whether or not to calculate the correlation coefficient of Gamma frailties. Must be TRUE or FALSE.}

\item{H0}{indicates whether or not to calculate the hessian and outer gradient matrix under the null hypothesis, see 'Details'.}

\item{h0}{the value against which is tested under the null}
}
\value{
\code{fit.nb.gf} returns estimates of the trend parameters \code{lambda}, dispersion parameter \code{size},
Hessian matrix \code{hessian}, outer gradient product matrix \code{ogradient} and, if inquired, correlation coefficient \code{rho}.
}
\description{
\code{fit.nb.gf} fits data using the pseudo maximum likelihood of a Gamma frailty model
}
\details{
the function \code{fit.nb.gf} fits a Gamma frailty model as found in Fiocco (2009). The fitting function allows for incomplete follow up,
but not for intermittent missingness.

When calculating the expected sandwich estimator required for the sample size, certain terms can not be computed analytically and have
to be approximated numerically. The value \code{approx} defines how close the approximation is to the true expected sandwich estimator.
High values of \code{approx} provide better approximations but are compuationally more expensive.

If parameter H0 is set to TRUE, the hessian and outer gradient are calculated under the assumption that \code{lambda[2]} \eqn{\geq} \code{h0} if
\code{trend = "constant"} or \code{lambda[3]} \eqn{\geq} \code{h0} if \code{trend = "exponential"}.
}
\examples{
#Generate data from the Gamma frailty model
random<-get.groups(n=c(1000,1000), size=c(0.7, 0.7), lambda=c(0.8, -0.5), rho=c(0.6, 0.6),
  tp=7, trend="constant")
fit.nb.gf(dataC=random[1001:2000,], dataE=random[1:1000,], trend="constant")
}
\references{
Fiocco M, Putter H, Van Houwelingen JC, (2009), A new serially correlated gamma-frailty process for longitudinal count data \emph{Biostatistics} Vol. 10, No. 2, pp. 245-257.
}
\seealso{
\code{\link{rnbinom.gf}} for information on the Gamma frailty model, \code{\link{n.nb.gf}} for calculating
initial sample size required when performing inference, \code{\link{bssr.nb.gf}} for blinded
sample size reestimation within a running trial, \code{\link{optim}} for more information on the used minimization algorithms.
}
