% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.sparsestep.R
\name{print.sparsestep}
\alias{print.sparsestep}
\title{Print the fitted SparseStep model}
\usage{
\method{print}{sparsestep}(x, ...)
}
\arguments{
\item{x}{a \code{sparsestep} object to print}

\item{\dots}{further argument are ignored}
}
\description{
Prints a short text of a fitted SparseStep model
}
\examples{
x <- matrix(rnorm(100*20), 100, 20)
y <- rnorm(100)
fit <- sparsestep(x, y)
print(fit)

}
\references{
Van den Burg, G.J.J., Groenen, P.J.F. and Alfons, A. (2017).
 \emph{SparseStep: Approximating the Counting Norm for Sparse Regularization},
 arXiv preprint arXiv:1701.06967 [stat.ME]. 
 URL \url{https://arxiv.org/abs/1701.06967}.
}
\author{
Gerrit J.J. van den Burg, Patrick J.F. Groenen, Andreas Alfons\cr
Maintainer: Gerrit J.J. van den Burg <gertjanvandenburg@gmail.com>
}
