% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spareg.R
\name{spar}
\alias{spar}
\alias{spareg}
\title{Sparse Projected Averaged Regression}
\usage{
spar(
  x,
  y,
  family = gaussian("identity"),
  model = NULL,
  rp = NULL,
  screencoef = NULL,
  xval = NULL,
  yval = NULL,
  nnu = 20,
  nus = NULL,
  nummods = c(20),
  measure = c("deviance", "mse", "mae", "class", "1-auc"),
  avg_type = c("link", "response"),
  parallel = FALSE,
  inds = NULL,
  RPMs = NULL,
  seed = NULL,
  ...
)

spareg(
  x,
  y,
  family = gaussian("identity"),
  model = NULL,
  rp = NULL,
  screencoef = NULL,
  xval = NULL,
  yval = NULL,
  nnu = 20,
  nus = NULL,
  nummods = c(20),
  measure = c("deviance", "mse", "mae", "class", "1-auc"),
  avg_type = c("link", "response"),
  parallel = FALSE,
  inds = NULL,
  RPMs = NULL,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{n x p numeric matrix of predictor variables.}

\item{y}{quantitative response vector of length n.}

\item{family}{a \link[stats]{family}  object used for the marginal generalized linear model,
default \code{gaussian("identity")}.}

\item{model}{function creating a \code{'sparmodel'} object;
defaults to \code{spar_glm()} for gaussian family with identity link and to
\code{spar_glmnet()} for all other family-link combinations.}

\item{rp}{function creating a \code{'randomprojection'} object. Defaults to NULL.
In this case \code{rp_cw(data = TRUE)} is used.}

\item{screencoef}{function creating a \code{'screeningcoef'} object. Defaults to NULL.
In this case no screening is used is used.}

\item{xval}{optional matrix of predictor variables observations used for
validation of threshold nu and number of models; \code{x} is used
if not provided.}

\item{yval}{optional response observations used for validation of
threshold nu and number of models; \code{y} is used if not provided.}

\item{nnu}{number of different threshold values \eqn{\nu} to consider for thresholding;
ignored when nus are given; defaults to 20.}

\item{nus}{optional vector of \eqn{\nu}'s to consider for thresholding;
if not provided, \code{nnu} values ranging from 0 to the maximum absolute
marginal coefficient are used.}

\item{nummods}{vector of numbers of marginal models to consider for
validation; defaults to \code{c(20)}.}

\item{measure}{loss to use for validation; defaults to \code{"deviance"}
available for all families. Other options are \code{"mse"} or \code{"mae"}
(between responses and predicted means, for all families),
\code{"class"} (misclassification error) and
\code{"1-auc"} (one minus area under the ROC curve) both just for
binomial family.}

\item{avg_type}{type of averaging the marginal models; either on link (default)
or on response level. This is used in computing the validation measure.}

\item{parallel}{assuming a parallel backend is loaded and available, a
logical indicating whether the function should use it in parallelizing the
estimation of the marginal models. Defaults to FALSE.}

\item{inds}{optional list of index-vectors corresponding to variables kept
after screening in each marginal model of length \code{max(nummods)};
dimensions need to fit those of RPMs.}

\item{RPMs}{optional list of projection matrices used in each
marginal model of length \code{max(nummods)}, diagonal elements will be
overwritten with a coefficient only depending on the given \code{x} and \code{y}.}

\item{seed}{integer seed to be set at the beginning of the SPAR algorithm. Default to NULL, in which case no seed is set.}

\item{...}{further arguments mainly to ensure back-compatibility}
}
\value{
object of class \code{'spar'} with elements
\itemize{
\item \code{betas} p x \code{max(nummods)} sparse matrix of class
\code{'\link[Matrix:dgCMatrix-class]{Matrix::dgCMatrix}'} containing the
standardized coefficients from each marginal model
\item \code{intercepts} used in each marginal model
\item \code{scr_coef} vector of length p with coefficients used for screening the standardized predictors
\item \code{inds} list of index-vectors corresponding to variables kept after screening in each marginal model of length max(nummods)
\item \code{RPMs} list of projection matrices used in each marginal model of length \code{max(nummods)}
\item \code{val_res} \code{data.frame} with validation results (validation measure
and number of active variables) for each element of \code{nus} and \code{nummods}
\item \code{val_set} logical flag, whether validation data were provided;
if \code{FALSE}, training data were used for validation
\item \code{family}  a character corresponding to \link[stats]{family}  object used for the marginal generalized linear model e.g.,
\code{"gaussian(identity)"}
\item \code{nus} vector of \eqn{\nu}'s considered for thresholding
\item \code{nummods} vector of numbers of marginal models considered for validation
\item \code{ycenter} empirical mean of initial response vector
\item \code{yscale} empirical standard deviation of initial response vector
\item \code{xcenter} p-vector of empirical means of initial predictor variables
\item \code{xscale} p-vector of empirical standard deviations of initial predictor variables
\item \code{avg_type} character, averaging type for computing the validation measure
\item \code{measure} character, type of validation measure used
\item \code{rp} an object of class \code{"randomprojection"}
\item \code{screencoef} an object of class \code{"screeningcoef"}
\item \code{x_rows_for_fitting_marginal_models} vector of row indicators from
\code{x} which were used for fitting the marginal models, if screening was performed
using \code{screencoef} with \code{split_data_prop} argument. Is \code{NULL} otherwise.
}
If a parallel backend is registered and \code{parallel = TRUE},
the \link[foreach]{foreach} function
is used to estimate the marginal models in parallel.
}
\description{
Apply Sparse Projected Averaged Regression to high-dimensional data by
building an ensemble of generalized linear models, where the high-dimensional
predictors can be screened using a screening coefficient and then projected
using data-agnostic or data-informed random projection matrices.
This function performs the procedure for a given grid of thresholds \eqn{\nu}
and a grid of the number of marginal models to be employed in the ensemble.
This function is also used in the cross-validated procedure \link{spar.cv}.
}
\examples{
example_data <- simulate_spareg_data(n = 200, p = 400, ntest = 100)
spar_res <- spar(example_data$x, example_data$y, xval = example_data$xtest,
  yval = example_data$ytest, nummods=c(5, 10, 15, 20, 25, 30))
coefs <- coef(spar_res)
pred <- predict(spar_res, xnew = example_data$x)
plot(spar_res)
plot(spar_res, plot_type = "val_measure", plot_along = "nummod", nu = 0)
plot(spar_res, plot_type = "val_measure", plot_along = "nu", nummod = 10)
plot(spar_res, plot_type = "val_numactive",  plot_along = "nummod", nu = 0)
plot(spar_res, plot_type = "val_numactive",  plot_along = "nu", nummod = 10)
plot(spar_res, plot_type = "res_vs_fitted",  xfit = example_data$xtest,
  yfit = example_data$ytest)
plot(spar_res, plot_type = "coefs", prange = c(1,400))

spar_res <- spareg(example_data$x, example_data$y, xval = example_data$xtest,
  yval = example_data$ytest, nummods=c(5, 10, 15, 20, 25, 30))
}
\references{
{
\insertRef{parzer2024lm}{spareg}

\insertRef{parzer2024glms}{spareg}

\insertRef{Clarkson2013LowRankApprox}{spareg}

\insertRef{ACHLIOPTAS2003JL}{spareg}
}
}
\seealso{
\link{spar.cv}, \link{coef.spar}, \link{predict.spar}, \link{plot.spar}, \link{print.spar}
}
