% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick-get.R
\name{spod_quick_get_od}
\alias{spod_quick_get_od}
\title{Get daily trip counts per origin-destionation municipality from 2022 onward}
\usage{
spod_quick_get_od(
  date = NA,
  min_trips = 100,
  distances = c("500m-2km", "2-10km", "10-50km", "50+km"),
  id_origin = NA,
  id_destination = NA
)
}
\arguments{
\item{date}{A character or Date object specifying the date for which to retrieve the data. If date is a character, the date must be in "YYYY-MM-DD" or "YYYYMMDD" format.}

\item{min_trips}{A numeric value specifying the minimum number of journeys per origin-destination pair to retrieve. Defaults to 100 to reduce the amount of data returned. Can be set to 0 to retrieve all data.}

\item{distances}{A character vector specifying the distances to retrieve. Valid values are "500m-2km", "2-10km", "10-50km", and "50+km". Defaults to \code{c("500m-2km", "2-10km", "10-50km", "50+km")}. The resulting data will not have number of trips per category of distance. Therefore, if you want to retrieve the number of trips per distance category, you need to make 4 separate calls to this function or use \code{\link[=spod_get]{spod_get()}} instead to get the full data from source CSV files.}

\item{id_origin}{A character vector specifying the origin municipalities to retrieve. If not provided, all origin municipalities will be included. Valid municipality IDs can be found in the dataset returned by \code{spod_get_zones(zones = "muni", ver = 2)}.}

\item{id_destination}{A character vector specifying the target municipalities to retrieve. If not provided, all target municipalities will be included. Valid municipality IDs can be found in the dataset returned by \code{spod_get_zones(zones = "muni", ver = 2)}.}
}
\value{
A \code{tibble} containing the flows for the specified date, minimum number of journeys, distances and origin-destination pairs if specified. The columns are:
\describe{
\item{date}{The date of the trips.}
\item{id_origin}{The origin municipality ID.}
\item{id_destination}{The target municipality ID.}
\item{n_trips}{The number of trips between the origin and target municipality.}
\item{trips_total_length_km}{The total length of trips in kilometers.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\strong{WARNING: this function may stop working at any time, as the API may change}. This function provides a quick way to get daily aggregated (no hourly data) trip counts per origin-destination municipality from v2 data (2022 onward). Compared to \code{\link[=spod_get]{spod_get()}}, which downloads large CSV files, this function downloads the data directly from the GraphQL API. An interactive web map with this data is available at \url{https://mapas-movilidad.transportes.gob.es/}. No data aggregation is performed on your computer (unlike in \code{\link[=spod_get]{spod_get()}}), so you do not need to worry about memory usage and do not have to use a powerful computer with multiple CPU cores just to get this simple data. Only about 1 MB of data is downloaded for a single day. The limitation of this function is that it can only retrieve data for a single day at a time and only with total number of trips and total km travelled. So it is not possible to get any of the extra variables available in the full dataset via \code{\link[=spod_get]{spod_get()}}.

For detailed data descriptions, see package vignettes using \code{\link[=spod_codebook]{spod_codebook(ver = 1)}} and \code{\link[=spod_codebook]{spod_codebook(ver = 2)}} and official methodology documents in \strong{References} section.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
\donttest{
od_1000 <- spod_quick_get_od(
  date = "2022-01-01",
  min_trips = 1000
)
}
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item \strong{For the official website of the mobility study}: \insertRef{mitms_mobility_web}{spanishoddata}
\item \strong{For v1 data methodology}: \insertRef{mitma_methodology_2020_v3}{spanishoddata}
\item \strong{For v2 data methodology}: \insertRef{mitms_methodology_2022_v8}{spanishoddata}
\item \strong{For the \code{spanishoddata} R package}: \insertRef{spanishoddata-r-pkg}{spanishoddata}
}

Use \code{\link[=spod_cite]{spod_cite()}} to cite the package and the data with correct plain text, markdown, or BibTeX formats.
}
