% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trophic.R
\name{normalize_weights}
\alias{normalize_weights}
\title{Normalize weights of a trophic table}
\usage{
normalize_weights(tbl)
}
\arguments{
\item{tbl}{A \code{trophic_tbl} object.}
}
\value{
A \code{trophic_tbl} object with an additional column
\code{normalized_weight}.
}
\description{
Adds a new column \code{normalized_weight} to a \code{trophic_tbl} object so that,
for each target node (\code{to}), the sum of incoming weights equals 1.
}
\details{
For every unique value in the \code{to} elements of the \code{link} column,
the function divides each corresponding weight by the total weight of all links
pointing to that same node.

Nodes with no incoming links are left unchanged.
}
\examples{
net <- trophic() |>
  add_link("a", "b", weight = 2) |>
  add_link("c", "b", weight = 3)

net_norm <- normalize_weights(net)

}
