% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sotkanet.R
\docType{package}
\name{sotkanet-package}
\alias{sotkanet-package}
\alias{sotkanet}
\title{sotkanet: Sotkanet Open Data Access and Analysis}
\description{
The `sotkanet` R package aims to make retrieval of sotkanet 
   indicator data easy using R. Sotkanet.fi Statistics and Indicator Bank is
   maintained by The Finnish Institute for Health and Welfare and it
   contains data on population welfare and health from 1990 onwards.
}
\section{sotkanet functions}{


   The main ways to interact with Sotkanet REST API are with the
   following functions: \code{\link{GetDataSotkanet}} for downloading data 
   from specific indicator(s), \code{\link{SotkanetIndicators}} for 
   retrieving metadata on all or user specified indicators as a well 
   defined list and \code{\link{SotkanetIndicatorMetadata}} as a 
   specialized case returning an untruncated ("raw") output as default.
}

\section{Attribution and licensing}{


   For citing this package, see \code{citation("sotkanet")}
   
   For terms of use of Sotkanet data, see THL 
   \href{https://yhteistyotilat.fi/wiki08/x/E4CkAQ}{Sotkanet REST API 
   documentation} (in Finnish). 
   
   A short and unofficial English summary of the Finnish Terms of use is as
   follows: The end user of this package should note that
   \itemize{
     \item{metadata related to regional classifications and indicators is 
     released under a \href{https://creativecommons.org/licenses/by/4.0/}{Creative 
     Commons Attribution 4.0 license (CC BY 4.0)}},
     \item{statistical data and indicators \strong{produced by THL} are 
     likewise released under a CC BY 4.0 license,}
     \item{statistical data and indicators produced by \strong{other parties 
     than THL} should be only used in accordance with a separate agreement.}
   }
   
   CC BY 4.0 terms state that when using data accessed through the sotkanet 
   API you should always give appropriate credit to Sotkanet as a data 
   source and include a link to sotkanet website: \emph{https://sotkanet.fi}. 
   In the case of individual indicators, the producer of the indicator 
   should also be attributed separately.
   
   This information is subject to change and the developers of this package
   cannot guarantee that information stated here is correct. This unofficial
   English translation related to data terms of use is provided solely
   as a convenience to the end user. The user of this package should always 
   check the full text of Sotkanet terms of use from the original source 
   (see the link above to Sotkanet REST API documentation).
}

\section{Basic information about the package}{


\tabular{ll}{
  Package: \tab sotkanet\cr
  Type: \tab Package\cr
  Version: \tab See sessionInfo() or DESCRIPTION file\cr
  Date: \tab 2013-2024\cr
  License: \tab BSD 2-clause License\cr
  LazyLoad: \tab yes\cr
}
}

\examples{
library(sotkanet)
}
\references{
See citation("sotkanet")
}
\seealso{
Useful links:
\itemize{
  \item \url{https://ropengov.github.io/sotkanet/}
  \item Report bugs at \url{https://github.com/ropengov/sotkanet/issues}
}

}
\author{
Leo Lahti (\email{leo.lahti@iki.fi}), Einari Happonen, Juuso Parkkinen Joona Lehtomaki, Vesa Saaristo, Pyry Kantanen and Aleksi Lahtinen
}
