% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability2.R
\name{stability2}
\alias{stability2}
\title{A function to run the stability analysis using the numerical simulation of the Jacobain matrix.}
\usage{
stability2(
  usin,
  DIETLIMTS = NA,
  diet_correct = TRUE,
  Conly = FALSE,
  userdefinedinputs = NA,
  has_inorganic_nitrogen = FALSE,
  inorganic_nitrogen_properties = list(INN = NA, q = NA, eqmN = NA),
  forstabilityonly = TRUE,
  densitydependence = NA
)
}
\arguments{
\item{usin}{The community for which to calculate stability.}

\item{DIETLIMTS}{The diet limits matrix for the stoichiometry correction (proportion of diet)?}

\item{diet_correct}{Boolean: Does the organism correct it's diet?}

\item{Conly}{Boolean: Is the model meant for carbon only?}

\item{userdefinedinputs}{Do you want to input a user defined vector of input functions? If NA the input values that keep the system at equilibrium are calculated. If not, put in a vector of input rates for each node.}

\item{has_inorganic_nitrogen}{Boolean: Is there an inorganic nitrogen pool?}

\item{inorganic_nitrogen_properties}{A list of state variables for the inorganic nitrogen pool (INN = inputs, q = per capita loss of N, eqmN = equilibrium N). Must include a value for two of the three variables and has the final one as NA.}

\item{forstabilityonly}{Boolean: Do you only want to check the stability of the carbon equations and inorganic nitrogen? If FALSE then changes in detritus nitrogen are also included.}

\item{densitydependence}{Which nodes have density dependence? NA default means none of them do. Should be a vector of 0 (no DD) and 1 (DD) for each node.}
}
\value{
The stability calculated by the Jacobian as a list of the Jacobian, eigenvalues, and the maximum eigenvalue.
}
\description{
A function to run the stability analysis using the numerical simulation of the Jacobain matrix.
}
\details{
The stability as defined by the Jacobian is estimated using the ordinary differential equations. Consequenlty, the parameters are retrieved using \code{\link{getPARAMS}} and then added to the function \code{\link[rootSolve]{jacobian.full}} using the ODE defined by \code{\link{foodwebode}} This stability function allows the user to define density-dependence by node as present or absent. If you want to apply a uniform level of density-dependence use the function 'stability' and choose the option Moorecobain.
}
\examples{
# Basic stability calculation:
stability2(intro_comm)

# Stability calculation with density-dependence for the animals:
stability2(intro_comm, densitydependence = c(1, 1, 1, 0, 0, 0, 0))
}
\seealso{
\code{\link{getPARAMS}} and \code{\link{foodwebode}} for functions which are called internally and \code{\link[rootSolve]{jacobian.full}} for the method used.
}
