% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comana.R
\name{comana}
\alias{comana}
\title{A function to calculate carbon and nitrogen fluxes in the food web.}
\usage{
comana(
  usin,
  mkplot = FALSE,
  whattoplot = c("web", "Nmin", "Cmin"),
  showCN = FALSE,
  BOX.SIZE = 0.1,
  BOX.PROP = 0.3,
  BOX.CEX = 1,
  PLOT.CEX = 1,
  edgepos = c(0.1, 0.9),
  TCK = 0.05,
  shuffleTL = FALSE,
  prettynames = NA,
  fwdlwdcust = NULL,
  arrowlog = FALSE,
  arrowsizerange = c(0.1, 30),
  rmzeros = TRUE,
  eqmtolerance = NA
)
}
\arguments{
\item{usin}{The community that you are analyzing: contains a matrix of interactions and a data frame of properties in a list.}

\item{mkplot}{Boolean: Should the plots be output?}

\item{whattoplot}{A vector of what to plot. Food web typology (web), nitrogen mineralization (Nmin), and/or carbon mineralization (Cmin).}

\item{showCN}{Boolean: # Should the food web show the C:N ratio of each trophic species next to it's name in the food web plot?}

\item{BOX.SIZE}{Size of boxes in the food web plot}

\item{BOX.PROP}{Proportion of box length and width in the food web plot}

\item{BOX.CEX}{Size of box text in the food web plot}

\item{PLOT.CEX}{Size of plot}

\item{edgepos}{Where to put the far left and far right boxes for trophic species in the food web plot (range = 0, 1).}

\item{TCK}{The size of the ticks on the C.min and N.min plots.}

\item{shuffleTL}{A Boolean stating whether the community should be sorted.}

\item{prettynames}{Alternative names in order for the food web plot trophic species. Cannot be used if showCN = T.}

\item{fwdlwdcust}{# A matrix of arrow line widths, same dimensions at the food web for plot customization.}

\item{arrowlog}{Boolean: Should relative arrow widths in the food web plot be on a log scale?}

\item{arrowsizerange}{The range of arrow sizes in the food web plot.}

\item{rmzeros}{A Boolean determining whether trophic species with zero biomass should be removed from the community before analysis.}

\item{eqmtolerance}{A value used to set the equilibrium tolerance for the food web verification. If NA, the default value used by the function all.equal is used, which is approximately 1.5e-8.}
}
\value{
A list of consumption rates, carbon mineralization, nitrogen mineralization, carbon and nitrogen consumption rates, and the modified community if zeros where removed or sorting occurred.
}
\description{
A function to calculate carbon and nitrogen fluxes in the food web.
}
\examples{
comana(intro_comm)
}
