% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soilchemistry.R
\name{Freundlich_A}
\alias{Freundlich_A}
\title{Freundlich isotherm fitted to adsorption data}
\usage{
Freundlich_A(W = W, V = V, Ci = Ci, Cf = Cf,...)
}
\arguments{
\item{W}{Mass of soil sample (g)}

\item{V}{Volume of extractant solution (mL)}

\item{Ci}{Initial concentration (mg/L) of the added element, e.g., phosphorus}

\item{Cf}{Final or equilibrium concentration (mg/L) after adsorption of the same element}

\item{...}{Any other argument that can be passed to base plot}
}
\value{
a - empirical constant (unitless)
1/n - empirical constant (unitless)
}
\description{
The linear form of Freundlich adsorption isotherm can be fitted to adsorption data to find out the empirical constants of Freundlich equation (Freundlich, 1926).
}
\details{
Freundlich equation/isotherm is used to study the adsorption behavior of any element in soils (Freundlich, 1926). It is of the general form: x/m= ac^(1/n), where ‘x’ is the amount of the adsorbate (e.g., P, Ni, etc.) adsorbed on ‘m’ amount of the adsorbent (e.g., soil), and ‘c’ is the equilibrium concentration of the adsorbate. This adsorption model helps to understand the relationship between quantity of any element adsorbed per unit soil weight and their concentration in soil solution. Freundlich equation does not predict or include maximum adsorption capacity of soil, so better suited to dilute solutions (of the element under consideration) in contact with the adsorbent. The ‘a’ and ‘1/n’ are two empirical-constants, sensitive to the given adsorbent-adsorbate system and temperature. Freundlich ‘a’ indicates the binding affinity of any element in soil. The ‘1/n’ is the exponent of the equilibrium concentration term in the Freundlich equation, and is always < 1 indicating that the energy of adsorption decreases logarithmically as the fraction of adsorbent-surface covered by the adsorbate increases with increasing equilibrium concentration.
}
\examples{
with(data = df_sordes, Freundlich_A(W = 2, V = 20, Ci = Initial_conc,
Cf = Equilibrium_conc))
}
\references{
Freundlich, H., 1926. Colloid and Capillary Chemistry. London: Methuen.
}
